/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.services;

import com.hotels.styx.NettyExecutor;
import com.hotels.styx.ObjectTagsKt;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.extension.service.spi.AbstractStyxService;
import com.hotels.styx.config.schema.Schema;
import com.hotels.styx.config.schema.SchemaDirective;
import com.hotels.styx.config.schema.SchemaDsl;
import com.hotels.styx.routing.RoutingObject;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.server.HttpInterceptorContext;
import com.hotels.styx.services.HealthCheckMonitoringService;
import com.hotels.styx.services.HealthCheckMonitoringServiceKt;
import com.hotels.styx.services.HealthChecksKt;
import com.hotels.styx.services.ObjectHealth;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 02\u00020\u0001:\u00010BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011JZ\u0010#\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010\u00140\u0014 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010\u00140\u0014\u0018\u00010$0$2\u001c\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180!0\u001fj\u0002`\"2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0006\u0010(\u001a\u00020\u0018J#\u0010)\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\b+J,\u0010,\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010.0. %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010.0.\u0018\u00010-0-H\u0014J,\u0010/\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010.0. %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010.0.\u0018\u00010-0-H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0012\u001a6\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180!0\u001fj\u0002`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/hotels/styx/services/HealthCheckMonitoringService;", "Lcom/hotels/styx/api/extension/service/spi/AbstractStyxService;", "objectStore", "Lcom/hotels/styx/routing/db/StyxObjectStore;", "Lcom/hotels/styx/routing/RoutingObjectRecord;", "application", "", "urlPath", "period", "Ljava/time/Duration;", "activeThreshold", "", "inactiveThreshold", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "workerExecutor", "Lcom/hotels/styx/NettyExecutor;", "(Lcom/hotels/styx/routing/db/StyxObjectStore;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;IILjava/util/concurrent/ScheduledExecutorService;Lcom/hotels/styx/NettyExecutor;)V", "determineObjectState", "Lkotlin/Function2;", "Lcom/hotels/styx/services/ObjectHealth;", "Lkotlin/ParameterName;", "name", "currentState", "", "reachable", "Lcom/hotels/styx/services/CheckState;", "futureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ScheduledFuture;", "probe", "Lkotlin/Function1;", "Lcom/hotels/styx/routing/RoutingObject;", "Lorg/reactivestreams/Publisher;", "Lcom/hotels/styx/services/Probe;", "healthCheck", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "routingObject", "previous", "isRunning", "runChecks", "", "runChecks$styx_proxy", "startService", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "stopService", "Companion", "styx-proxy"})
public final class HealthCheckMonitoringService
extends AbstractStyxService {
    private final Function1<RoutingObject, Publisher<Boolean>> probe;
    private final Function2<ObjectHealth, Boolean, ObjectHealth> determineObjectState;
    private final AtomicReference<ScheduledFuture<?>> futureRef;
    private final StyxObjectStore<RoutingObjectRecord> objectStore;
    private final String application;
    private final Duration period;
    private final ScheduledExecutorService executor;
    @JvmField
    public static final Schema.FieldType SCHEMA;
    @NotNull
    private static final ScheduledThreadPoolExecutor EXECUTOR;
    private static final Logger LOGGER;
    public static final Companion Companion;

    protected CompletableFuture<Void> startService() {
        return CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ HealthCheckMonitoringService this$0;

            public final void run() {
                HealthCheckMonitoringService.Companion.getLOGGER$styx_proxy().info("started service for {} - {} - {}", (Object)new Object[]{HealthCheckMonitoringService.access$getApplication$p(this.this$0), HealthCheckMonitoringService.access$getPeriod$p(this.this$0).toMillis(), HealthCheckMonitoringService.access$getPeriod$p(this.this$0).toMillis()});
                HealthCheckMonitoringService.access$getFutureRef$p(this.this$0).set(HealthCheckMonitoringService.access$getExecutor$p(this.this$0).scheduleAtFixedRate(new Runnable(this){
                    final /* synthetic */ startService.1 this$0;

                    public final void run() {
                        this.this$0.this$0.runChecks$styx_proxy(HealthCheckMonitoringService.access$getApplication$p(this.this$0.this$0), HealthCheckMonitoringService.access$getObjectStore$p(this.this$0.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, HealthCheckMonitoringService.access$getPeriod$p(this.this$0).toMillis(), HealthCheckMonitoringService.access$getPeriod$p(this.this$0).toMillis(), TimeUnit.MILLISECONDS));
            }
            {
                this.this$0 = healthCheckMonitoringService;
            }
        });
    }

    protected CompletableFuture<Void> stopService() {
        return CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ HealthCheckMonitoringService this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$filterTo$iv$iv;
                HealthCheckMonitoringService.Companion.getLOGGER$styx_proxy().info("stopped service for {}", (Object)HealthCheckMonitoringService.access$getApplication$p(this.this$0));
                Iterable $this$filter$iv = HealthCheckMonitoringService.access$getObjectStore$p(this.this$0).entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry p1 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!HealthCheckMonitoringServiceKt.access$containsRelevantStateTag(p1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Map.Entry $dstr$name$record = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$name$record;
                    boolean bl2 = false;
                    String name = (String)entry.getKey();
                    entry = $dstr$name$record;
                    bl2 = false;
                    RoutingObjectRecord record = (RoutingObjectRecord)entry.getValue();
                    HealthCheckMonitoringService.access$getObjectStore$p(this.this$0).compute(name, stopService.2.1.INSTANCE);
                }
                ((ScheduledFuture)HealthCheckMonitoringService.access$getFutureRef$p(this.this$0).get()).cancel(false);
            }
            {
                this.this$0 = healthCheckMonitoringService;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRunning() {
        ScheduledFuture<?> scheduledFuture = this.futureRef.get();
        if (scheduledFuture == null) return false;
        ScheduledFuture<?> scheduledFuture2 = scheduledFuture;
        boolean bl = false;
        boolean bl2 = false;
        ScheduledFuture<?> it = scheduledFuture2;
        boolean bl3 = false;
        if (it.isCancelled()) return false;
        if (it.isDone()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void runChecks$styx_proxy(@NotNull String application, @NotNull StyxObjectStore<RoutingObjectRecord> objectStore) {
        void $this$mapTo$iv$iv;
        ObjectHealth objectHealth;
        Pair $dstr$_u24__u24$record;
        Iterable $this$filterTo$iv$iv;
        Pair pair;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull(objectStore, (String)"objectStore");
        Iterable $this$map$iv = objectStore.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = new Pair(it.getKey(), it.getValue());
            collection.add(pair);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            $dstr$_u24__u24$record = (Pair)element$iv$iv;
            boolean bl = false;
            RoutingObjectRecord record = (RoutingObjectRecord)$dstr$_u24__u24$record.component2();
            if (!record.getTags().contains(ObjectTagsKt.getLbGroupTag().invoke(application))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$name$record;
            $dstr$_u24__u24$record = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$record.component1();
            RoutingObjectRecord record = (RoutingObjectRecord)$dstr$name$record.component2();
            Set<String> tags = record.getTags();
            objectHealth = HealthCheckMonitoringServiceKt.objectHealthFrom((String)ObjectTagsKt.getStateTag().find(tags), (Pair<String, Integer>)((Pair)ObjectTagsKt.getHealthCheckTag().find(tags)));
            pair = new Triple((Object)name, (Object)record, (Object)objectHealth);
            collection.add(pair);
        }
        List monitoredObjects = (List)destination$iv$iv;
        Iterable $this$map$iv2 = monitoredObjects;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$record$objectHealth;
            Triple bl = (Triple)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String name = (String)$dstr$name$record$objectHealth.component1();
            RoutingObjectRecord record = (RoutingObjectRecord)$dstr$name$record$objectHealth.component2();
            objectHealth = (ObjectHealth)$dstr$name$record$objectHealth.component3();
            pair = this.healthCheck(this.probe, record.getRoutingObject(), objectHealth).map(new Function<T, R>(name, objectHealth){
                final /* synthetic */ String $name;
                final /* synthetic */ ObjectHealth $objectHealth;

                @NotNull
                public final Triple<String, ObjectHealth, ObjectHealth> apply(ObjectHealth newHealth) {
                    return new Triple((Object)this.$name, (Object)this.$objectHealth, (Object)newHealth);
                }
                {
                    this.$name = string;
                    this.$objectHealth = objectHealth;
                }
            }).doOnNext((Consumer)new Consumer<Triple<? extends String, ? extends ObjectHealth, ? extends ObjectHealth>>(this, objectStore){
                final /* synthetic */ HealthCheckMonitoringService this$0;
                final /* synthetic */ StyxObjectStore $objectStore$inlined;
                {
                    this.this$0 = healthCheckMonitoringService;
                    this.$objectStore$inlined = styxObjectStore;
                }

                public final void accept(Triple<String, ? extends ObjectHealth, ? extends ObjectHealth> $dstr$name$currentHealth$newHealth) {
                    ObjectHealth newHealth;
                    String name = (String)$dstr$name$currentHealth$newHealth.component1();
                    ObjectHealth currentHealth = (ObjectHealth)$dstr$name$currentHealth$newHealth.component2();
                    if (Intrinsics.areEqual((Object)currentHealth, (Object)(newHealth = (ObjectHealth)$dstr$name$currentHealth$newHealth.component3())) ^ true) {
                        ObjectHealth objectHealth = newHealth;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectHealth, (String)"newHealth");
                        HealthCheckMonitoringServiceKt.access$markObject(this.$objectStore$inlined, name, objectHealth);
                    }
                }
            });
            collection.add(pair);
        }
        List pendingHealthChecks2 = (List)destination$iv$iv2;
        Flux.fromIterable((Iterable)pendingHealthChecks2).flatMap((Function)runChecks.1.INSTANCE).collectList().subscribe((Consumer)new Consumer<List<Triple<? extends String, ? extends ObjectHealth, ? extends ObjectHealth>>>(application){
            final /* synthetic */ String $application;

            public final void accept(List<Triple<String, ObjectHealth, ObjectHealth>> it) {
                List<Triple<String, ObjectHealth, ObjectHealth>> list = it;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it");
                String details2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<Triple<? extends String, ? extends ObjectHealth, ? extends ObjectHealth>, String>(this){
                    final /* synthetic */ runChecks.2 this$0;

                    @NotNull
                    public final String invoke(Triple<String, ? extends ObjectHealth, ? extends ObjectHealth> $dstr$name$_u24__u24$health2) {
                        String name = (String)$dstr$name$_u24__u24$health2.component1();
                        ObjectHealth health2 = (ObjectHealth)$dstr$name$_u24__u24$health2.component3();
                        return "{ app: " + this.this$0.$application + ", host: " + name + ", result: " + health2 + " }";
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)30, null);
                HealthCheckMonitoringService.Companion.getLOGGER$styx_proxy().debug("Health Check Completed: " + details2);
            }
            {
                this.$application = string;
            }
        });
    }

    private final Mono<ObjectHealth> healthCheck(Function1<? super RoutingObject, ? extends Publisher<Boolean>> probe, RoutingObject routingObject, ObjectHealth previous) {
        return MonoExtensionsKt.toMono((Publisher)((Publisher)probe.invoke((Object)routingObject))).map(new Function<T, R>(this, previous){
            final /* synthetic */ HealthCheckMonitoringService this$0;
            final /* synthetic */ ObjectHealth $previous;

            @NotNull
            public final ObjectHealth apply(Boolean reachable) {
                Function2 function2 = HealthCheckMonitoringService.access$getDetermineObjectState$p(this.this$0);
                Boolean bl = reachable;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"reachable");
                return (ObjectHealth)function2.invoke((Object)this.$previous, (Object)bl);
            }
            {
                this.this$0 = healthCheckMonitoringService;
                this.$previous = objectHealth;
            }
        });
    }

    public HealthCheckMonitoringService(@NotNull StyxObjectStore<RoutingObjectRecord> objectStore, @NotNull String application, @NotNull String urlPath, @NotNull Duration period, int activeThreshold, int inactiveThreshold, @NotNull ScheduledExecutorService executor, @NotNull NettyExecutor workerExecutor2) {
        Intrinsics.checkParameterIsNotNull(objectStore, (String)"objectStore");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)urlPath, (String)"urlPath");
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor2, (String)"workerExecutor");
        super("HealthCheckMonitoringService-" + application);
        this.objectStore = objectStore;
        this.application = application;
        this.period = period;
        this.executor = executor;
        HttpRequest httpRequest = HttpRequest.get((String)urlPath).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest, (String)"HttpRequest.get(urlPath).build()");
        Duration duration = Duration.ofMillis(1000L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(1000)");
        this.probe = HealthChecksKt.urlProbe(httpRequest, duration, (HttpInterceptor.Context)new HttpInterceptorContext(false, null, (Executor)workerExecutor2.eventLoopGroup()));
        this.determineObjectState = HealthChecksKt.healthCheckFunction(activeThreshold, inactiveThreshold);
        this.futureRef = new AtomicReference();
    }

    public /* synthetic */ HealthCheckMonitoringService(StyxObjectStore styxObjectStore, String string, String string2, Duration duration, int n, int n2, ScheduledExecutorService scheduledExecutorService, NettyExecutor nettyExecutor, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x80) != 0) {
            NettyExecutor nettyExecutor2 = HealthCheckMonitoringServiceKt.access$getHealthCheckExecutor$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)nettyExecutor2, (String)"healthCheckExecutor");
            nettyExecutor = nettyExecutor2;
        }
        this(styxObjectStore, string, string2, duration, n, n2, scheduledExecutorService, nettyExecutor);
    }

    static {
        Companion = new Companion(null);
        SCHEMA = SchemaDsl.object((SchemaDirective[])new SchemaDirective[]{(SchemaDirective)SchemaDsl.field((String)"objects", (Schema.FieldType)SchemaDsl.string()), (SchemaDirective)SchemaDsl.optional((String)"path", (Schema.FieldType)SchemaDsl.string()), (SchemaDirective)SchemaDsl.optional((String)"timeoutMillis", (Schema.FieldType)SchemaDsl.integer()), (SchemaDirective)SchemaDsl.optional((String)"intervalMillis", (Schema.FieldType)SchemaDsl.integer()), (SchemaDirective)SchemaDsl.optional((String)"healthyThreshold", (Schema.FieldType)SchemaDsl.integer()), (SchemaDirective)SchemaDsl.optional((String)"unhealthyThreshold", (Schema.FieldType)SchemaDsl.integer())});
        EXECUTOR = new ScheduledThreadPoolExecutor(2);
        LOGGER = LoggerFactory.getLogger(HealthCheckMonitoringService.class);
    }

    public static final /* synthetic */ String access$getApplication$p(HealthCheckMonitoringService $this) {
        return $this.application;
    }

    public static final /* synthetic */ Duration access$getPeriod$p(HealthCheckMonitoringService $this) {
        return $this.period;
    }

    public static final /* synthetic */ AtomicReference access$getFutureRef$p(HealthCheckMonitoringService $this) {
        return $this.futureRef;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getExecutor$p(HealthCheckMonitoringService $this) {
        return $this.executor;
    }

    public static final /* synthetic */ StyxObjectStore access$getObjectStore$p(HealthCheckMonitoringService $this) {
        return $this.objectStore;
    }

    public static final /* synthetic */ Function2 access$getDetermineObjectState$p(HealthCheckMonitoringService $this) {
        return $this.determineObjectState;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hotels/styx/services/HealthCheckMonitoringService$Companion;", "", "()V", "EXECUTOR", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getEXECUTOR$styx_proxy", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$styx_proxy", "()Lorg/slf4j/Logger;", "SCHEMA", "Lcom/hotels/styx/config/schema/Schema$FieldType;", "styx-proxy"})
    public static final class Companion {
        @NotNull
        public final ScheduledThreadPoolExecutor getEXECUTOR$styx_proxy() {
            return EXECUTOR;
        }

        public final Logger getLOGGER$styx_proxy() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

