/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.services;

import com.hotels.styx.NettyExecutor;
import com.hotels.styx.NullableValueTag;
import com.hotels.styx.ObjectTagsKt;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.services.HealthCheckMonitoringServiceKt;
import com.hotels.styx.services.ObjectActive;
import com.hotels.styx.services.ObjectHealth;
import com.hotels.styx.services.ObjectOther;
import com.hotels.styx.services.ObjectUnreachable;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a(\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0000\u001a$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"RELEVANT_STATES", "", "", "healthCheckExecutor", "Lcom/hotels/styx/NettyExecutor;", "kotlin.jvm.PlatformType", "containsRelevantStateTag", "", "entry", "", "Lcom/hotels/styx/routing/RoutingObjectRecord;", "markObject", "", "db", "Lcom/hotels/styx/routing/db/StyxObjectStore;", "name", "newStatus", "Lcom/hotels/styx/services/ObjectHealth;", "objectHealthFrom", "state", "health", "Lkotlin/Pair;", "", "reTag", "tags", "styx-proxy"})
public final class HealthCheckMonitoringServiceKt {
    private static final NettyExecutor healthCheckExecutor = NettyExecutor.create((String)"HealthCheckMonitoringService-global", (int)1);
    private static final Set<String> RELEVANT_STATES = SetsKt.setOf((Object[])new String[]{"active", "unreachable"});

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final ObjectHealth objectHealthFrom(@Nullable String state, @Nullable Pair<String, Integer> health) {
        ObjectHealth objectHealth;
        if (Intrinsics.areEqual((Object)state, (Object)"active")) {
            Pair<String, Integer> pair = health;
            if (Intrinsics.areEqual((Object)(pair != null ? (String)pair.getFirst() : null), (Object)"probes-FAIL") && ((Number)health.getSecond()).intValue() >= 0) {
                objectHealth = new ObjectActive(((Number)health.getSecond()).intValue(), false, false, 6, null);
                return objectHealth;
            }
        }
        if (Intrinsics.areEqual((Object)state, (Object)"unreachable")) {
            Pair<String, Integer> pair = health;
            if (Intrinsics.areEqual((Object)(pair != null ? (String)pair.getFirst() : null), (Object)"probes-OK") && ((Number)health.getSecond()).intValue() >= 0) {
                objectHealth = new ObjectUnreachable(((Number)health.getSecond()).intValue(), false, 2, null);
                return objectHealth;
            }
        }
        if (Intrinsics.areEqual((Object)state, (Object)"active")) {
            objectHealth = new ObjectActive(0, false, health != null, 2, null);
            return objectHealth;
        }
        if (Intrinsics.areEqual((Object)state, (Object)"unreachable")) {
            objectHealth = new ObjectUnreachable(0, health != null);
            return objectHealth;
        }
        if (state != null) {
            objectHealth = new ObjectOther(state);
            return objectHealth;
        }
        objectHealth = new ObjectUnreachable(0, health != null);
        return objectHealth;
    }

    private static final void markObject(StyxObjectStore<RoutingObjectRecord> db, String name, ObjectHealth newStatus) {
        db.compute(name, (Function1<RoutingObjectRecord, RoutingObjectRecord>)((Function1)new Function1<RoutingObjectRecord, RoutingObjectRecord>(newStatus){
            final /* synthetic */ ObjectHealth $newStatus;

            @Nullable
            public final RoutingObjectRecord invoke(@Nullable RoutingObjectRecord previous) {
                Set<String> newTags;
                if (previous == null) {
                    return null;
                }
                Set<String> prevTags = previous.getTags();
                return Intrinsics.areEqual(prevTags, newTags = HealthCheckMonitoringServiceKt.reTag(prevTags, this.$newStatus)) ^ true ? RoutingObjectRecord.copy$default(previous, null, newTags, null, null, 13, null) : previous;
            }
            {
                this.$newStatus = objectHealth;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Set<String> reTag(@NotNull Set<String> tags, @NotNull ObjectHealth newStatus) {
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull((Object)newStatus, (String)"newStatus");
        Sequence sequence = SequencesKt.plus((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)tags), (Function1)reTag.1.INSTANCE), (Object)ObjectTagsKt.getStateTag().invoke(newStatus.state()));
        NullableValueTag<Pair<String, Integer>> nullableValueTag = ObjectTagsKt.getHealthCheckTag();
        Pair<String, Integer> pair = newStatus.health();
        if (pair == null) {
            Intrinsics.throwNpe();
        }
        return SequencesKt.toSet((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)sequence, (Object)nullableValueTag.invoke(pair))));
    }

    private static final boolean containsRelevantStateTag(Map.Entry<String, RoutingObjectRecord> entry) {
        return CollectionsKt.contains((Iterable)RELEVANT_STATES, ObjectTagsKt.getStateTag().find(entry.getValue().getTags()));
    }

    public static final /* synthetic */ boolean access$containsRelevantStateTag(Map.Entry entry) {
        return HealthCheckMonitoringServiceKt.containsRelevantStateTag(entry);
    }

    public static final /* synthetic */ void access$markObject(StyxObjectStore db, String name, ObjectHealth newStatus) {
        HealthCheckMonitoringServiceKt.markObject(db, name, newStatus);
    }

    public static final /* synthetic */ NettyExecutor access$getHealthCheckExecutor$p() {
        return healthCheckExecutor;
    }
}

