/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.spi;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.spi.ClassSource;
import com.hotels.styx.spi.ClassSourceLocator;
import com.hotels.styx.spi.ExtensionLoadingException;
import com.hotels.styx.spi.config.SpiExtensionFactory;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Function;

public class ExtensionObjectFactory {
    public static final ExtensionObjectFactory EXTENSION_OBJECT_FACTORY = new ExtensionObjectFactory();
    private final Function<SpiExtensionFactory, ClassSource> extensionLocator;

    private ExtensionObjectFactory() {
        this(ExtensionObjectFactory::locateExtension);
    }

    @VisibleForTesting
    ExtensionObjectFactory(Function<SpiExtensionFactory, ClassSource> extensionLocator) {
        this.extensionLocator = Objects.requireNonNull(extensionLocator);
    }

    public <T> T newInstance(SpiExtensionFactory extensionFactory, Class<T> type) throws ExtensionLoadingException {
        try {
            Class<?> extensionClass = this.loadClass(extensionFactory);
            Object instance = extensionClass.newInstance();
            return type.cast(instance);
        }
        catch (ExtensionLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtensionLoadingException("error instantiating class=" + extensionFactory.factoryClass(), e);
        }
    }

    private Class<?> loadClass(SpiExtensionFactory extensionFactory) throws ExtensionLoadingException {
        ClassSource classSource = this.extensionLocator.apply(extensionFactory);
        try {
            return classSource.load(extensionFactory.factoryClass());
        }
        catch (ClassNotFoundException e) {
            throw new ExtensionLoadingException(ExtensionObjectFactory.classNotFoundMessage(extensionFactory), e);
        }
    }

    private static ClassSource locateExtension(SpiExtensionFactory extensionFactory) {
        if (ExtensionObjectFactory.nonEmpty(extensionFactory.classPath())) {
            return ClassSourceLocator.JARS.classSource(Paths.get(extensionFactory.classPath(), new String[0]));
        }
        return ClassSource.fromClassLoader(ExtensionObjectFactory.class.getClassLoader());
    }

    private static String classNotFoundMessage(SpiExtensionFactory extensionFactory) {
        String exceptionFormat = ExtensionObjectFactory.nonEmpty(extensionFactory.classPath()) ? "no class=%s is found in the specified classpath=%s" : "no class=%s is found (no classpath specified)";
        return String.format(exceptionFormat, extensionFactory.factoryClass(), extensionFactory.classPath());
    }

    private static boolean nonEmpty(String classPath) {
        return classPath != null && !classPath.trim().isEmpty();
    }
}

