/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.spi;

import com.google.common.collect.ImmutableList;
import com.hotels.styx.api.Resource;
import com.hotels.styx.common.io.FileResource;
import com.hotels.styx.common.io.FileResourceIndex;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

final class JarResources {
    private JarResources() {
    }

    static Collection<Resource> jars(Path path) {
        return JarResources.isJarResource(path) ? Collections.singleton(JarResources.singleResource(path)) : JarResources.multipleResources(path);
    }

    private static boolean isJarResource(Path path) {
        return path.toFile().getName().endsWith(".jar");
    }

    private static FileResource singleResource(Path path) {
        return new FileResource(path.toFile());
    }

    private static Collection<Resource> multipleResources(Path path) {
        FileResourceIndex resourceIndex = new FileResourceIndex();
        return ImmutableList.copyOf((Iterable)resourceIndex.list(path.toString(), ".jar"));
    }
}

