/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.spi.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.hotels.styx.spi.config.SpiExtensionFactory;
import java.io.IOException;
import java.util.Objects;

public class SpiExtension {
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final SpiExtensionFactory factory;
    private final JsonNode config;
    private final boolean enabled;

    @JsonCreator
    public SpiExtension(@JsonProperty(value="factory") SpiExtensionFactory factory, @JsonProperty(value="config") JsonNode config, @JsonProperty(value="enabled") Boolean enabled) {
        this.factory = Objects.requireNonNull(factory, "Factory attribute missing");
        this.config = Objects.requireNonNull(config, "Config attribute missing");
        this.enabled = enabled == null;
    }

    public SpiExtensionFactory factory() {
        return this.factory;
    }

    public JsonNode config() {
        return this.config;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public <T> T config(Class<T> configClass) {
        JsonParser parser = this.config.traverse();
        try {
            return (T)MAPPER.readValue(parser, configClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.factory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpiExtension other = (SpiExtension)obj;
        return Objects.equals(this.factory, other.factory);
    }

    public String toString() {
        return new StringBuilder(32).append(this.getClass().getSimpleName()).append("{factory=").append(this.factory).append('}').toString();
    }
}

