/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.hotels.styx.Version;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.metrics.reporting.sets.NettyAllocatorMetricSet;
import com.hotels.styx.metrics.reporting.sets.OperatingSystemMetricSet;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoreMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(CoreMetrics.class);

    private CoreMetrics() {
    }

    public static void registerCoreMetrics(Version buildInfo, MetricRegistry metrics) {
        CoreMetrics.registerVersionMetric(buildInfo, metrics);
        CoreMetrics.registerJvmMetrics(metrics);
        metrics.register("os", (Metric)new OperatingSystemMetricSet());
    }

    private static void registerVersionMetric(Version buildInfo, MetricRegistry metrics) {
        Optional<Integer> buildNumber = buildInfo.buildNumber();
        if (buildNumber.isPresent()) {
            CoreMetrics.registerVersionMetric(metrics, buildNumber.get());
        } else {
            LOG.warn("Could not acquire build number from release version: {}", (Object)buildInfo);
        }
    }

    private static void registerVersionMetric(MetricRegistry metricRegistry, Integer buildNumber) {
        Gauge versionGauge = () -> buildNumber;
        metricRegistry.scope("styx").register("version.buildnumber", (Metric)versionGauge);
    }

    private static void registerJvmMetrics(MetricRegistry metricRegistry) {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        MetricRegistry scoped = metricRegistry.scope("jvm");
        scoped.register("bufferpool", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        scoped.register("memory", (Metric)new MemoryUsageGaugeSet());
        scoped.register("thread", (Metric)new ThreadStatesGaugeSet());
        scoped.register("gc", (Metric)new GarbageCollectorMetricSet());
        scoped.register("uptime", (Metric)((Gauge)runtimeMxBean::getUptime));
        scoped.register("uptime.formatted", (Metric)((Gauge)() -> CoreMetrics.formatTime(runtimeMxBean.getUptime())));
        scoped.register("netty", (Metric)new NettyAllocatorMetricSet("pooled-allocator", (ByteBufAllocatorMetric)PooledByteBufAllocator.DEFAULT.metric()));
        scoped.register("netty", (Metric)new NettyAllocatorMetricSet("unpooled-allocator", UnpooledByteBufAllocator.DEFAULT.metric()));
    }

    private static String formatTime(long timeInMilliseconds) {
        Duration duration = Duration.ofMillis(timeInMilliseconds);
        long days = duration.toDays();
        long hours = duration.minusDays(days).toHours();
        long minutes = duration.minusHours(duration.toHours()).toMinutes();
        return String.format("%dd %dh %dm", days, hours, minutes);
    }
}

