/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.hotels.styx.Environment;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.StartupConfig;
import com.hotels.styx.StyxConfig;
import com.hotels.styx.StyxObjectRecord;
import com.hotels.styx.Version;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.extension.service.spi.StyxService;
import com.hotels.styx.api.metrics.codahale.CodaHaleMetricRegistry;
import com.hotels.styx.api.plugins.spi.Plugin;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.common.format.SanitisedHttpHeaderFormatter;
import com.hotels.styx.common.format.SanitisedHttpMessageFormatter;
import com.hotels.styx.executors.NettyExecutorConfig;
import com.hotels.styx.infrastructure.configuration.yaml.JsonNodeConfig;
import com.hotels.styx.infrastructure.logging.LOGBackConfigurer;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.routing.RoutingObjectRecord;
import com.hotels.styx.routing.config.Builtins;
import com.hotels.styx.routing.config.HttpInterceptorFactory;
import com.hotels.styx.routing.config.RoutingObjectFactory;
import com.hotels.styx.routing.config.StyxObjectDefinition;
import com.hotels.styx.routing.db.StyxObjectStore;
import com.hotels.styx.routing.handlers.RouteRefLookup;
import com.hotels.styx.startup.ServicesLoader;
import com.hotels.styx.startup.extensions.ConfiguredPluginFactory;
import com.hotels.styx.startup.extensions.PluginLoadingForStartup;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyxServerComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyxServerComponents.class);
    private static final String NETTY_EXECUTOR = "NettyExecutor";
    private static final String GLOBAL_SERVER_BOSS_NAME = "StyxHttpServer-Global-Boss";
    private static final String GLOBAL_SERVER_WORKER_NAME = "StyxHttpServer-Global-Worker";
    private static final String GLOBAL_CLIENT_WORKER_NAME = "Styx-Client-Global-Worker";
    private final Environment environment;
    private final Map<String, StyxService> services;
    private final List<NamedPlugin> plugins;
    private final StyxObjectStore<RoutingObjectRecord> routeObjectStore = new StyxObjectStore();
    private final StyxObjectStore<StyxObjectRecord<StyxService>> providerObjectStore = new StyxObjectStore();
    private final StyxObjectStore<StyxObjectRecord<InetServer>> serverObjectStore = new StyxObjectStore();
    private final StyxObjectStore<StyxObjectRecord<NettyExecutor>> executorObjectStore = new StyxObjectStore();
    private final RoutingObjectFactory.Context routingObjectContext;
    private final StartupConfig startupConfig;
    private final NettyExecutor executor;

    private StyxServerComponents(Builder builder) {
        StyxConfig styxConfig = Objects.requireNonNull(builder.styxConfig);
        this.startupConfig = builder.startupConfig == null ? StartupConfig.newStartupConfigBuilder().build() : builder.startupConfig;
        ImmutableMap routingObjectFactories = new ImmutableMap.Builder().putAll(Builtins.BUILTIN_HANDLER_FACTORIES).putAll(builder.additionalRoutingObjectFactories).build();
        this.environment = StyxServerComponents.newEnvironment(styxConfig, builder.metricRegistry);
        builder.loggingSetUp.setUp(this.environment);
        this.executor = NettyExecutor.create((String)"Styx-Client-Worker", (int)this.environment.configuration().proxyServerConfig().clientWorkerThreadsCount());
        this.executorObjectStore.insert(GLOBAL_SERVER_BOSS_NAME, new StyxObjectRecord<NettyExecutor>(NETTY_EXECUTOR, (Set<String>)ImmutableSet.of((Object)"StyxInternal"), new NettyExecutorConfig(0, GLOBAL_SERVER_BOSS_NAME).asJsonNode(), NettyExecutor.create((String)GLOBAL_SERVER_BOSS_NAME, (int)0)));
        this.executorObjectStore.insert(GLOBAL_SERVER_WORKER_NAME, new StyxObjectRecord<NettyExecutor>(NETTY_EXECUTOR, (Set<String>)ImmutableSet.of((Object)"StyxInternal"), new NettyExecutorConfig(0, GLOBAL_SERVER_WORKER_NAME).asJsonNode(), NettyExecutor.create((String)GLOBAL_SERVER_WORKER_NAME, (int)0)));
        this.executorObjectStore.insert(GLOBAL_CLIENT_WORKER_NAME, new StyxObjectRecord<NettyExecutor>(NETTY_EXECUTOR, (Set<String>)ImmutableSet.of((Object)"StyxInternal"), new NettyExecutorConfig(0, GLOBAL_CLIENT_WORKER_NAME).asJsonNode(), NettyExecutor.create((String)GLOBAL_CLIENT_WORKER_NAME, (int)0)));
        this.environment.configuration().get("executors", JsonNode.class).map(StyxServerComponents::readComponents).orElse((Map)ImmutableMap.of()).forEach((name, definition) -> {
            LOGGER.warn("Loading styx server: " + name + ": " + definition);
            NettyExecutor executor = Builtins.buildExecutor(name, definition, Builtins.BUILTIN_EXECUTOR_FACTORIES);
            StyxObjectRecord<NettyExecutor> record = new StyxObjectRecord<NettyExecutor>(definition.type(), (Set<String>)ImmutableSet.copyOf(definition.tags()), definition.config(), executor);
            this.executorObjectStore.insert((String)name, record);
        });
        this.services = StyxServerComponents.mergeServices(builder.servicesLoader.load(this.environment, this.routeObjectStore), builder.additionalServices);
        this.plugins = builder.configuredPluginFactories.isEmpty() ? PluginLoadingForStartup.loadPlugins(this.environment) : PluginLoadingForStartup.loadPlugins(this.environment, builder.configuredPluginFactories);
        this.plugins.forEach(plugin -> this.environment.plugins().add((NamedPlugin)plugin));
        this.routingObjectContext = new RoutingObjectFactory.Context(new RouteRefLookup.RouteDbRefLookup(this.routeObjectStore), this.environment, this.routeObjectStore, (Map<String, RoutingObjectFactory>)routingObjectFactories, (Iterable<NamedPlugin>)this.plugins, (Map<String, HttpInterceptorFactory>)Builtins.INTERCEPTOR_FACTORIES, false, this.executorObjectStore);
        this.environment.configuration().get("routingObjects", JsonNode.class).map(StyxServerComponents::readComponents).orElse((Map)ImmutableMap.of()).forEach((name, definition) -> this.routeObjectStore.insert((String)name, RoutingObjectRecord.Companion.create(definition.type(), (Set<String>)ImmutableSet.copyOf(definition.tags()), definition.config(), Builtins.build((List<String>)ImmutableList.of((Object)name), this.routingObjectContext, definition))).ifPresent(previous -> previous.getRoutingObject().stop()));
        this.environment.configuration().get("providers", JsonNode.class).map(StyxServerComponents::readComponents).orElse((Map)ImmutableMap.of()).forEach((name, definition) -> {
            LOGGER.warn("Loading provider: " + name + ": " + definition);
            StyxService provider = Builtins.build(name, definition, this.providerObjectStore, Builtins.BUILTIN_SERVICE_PROVIDER_FACTORIES, this.routingObjectContext);
            StyxObjectRecord<StyxService> record = new StyxObjectRecord<StyxService>(definition.type(), (Set<String>)ImmutableSet.copyOf(definition.tags()), definition.config(), provider);
            this.providerObjectStore.insert((String)name, record);
        });
        this.environment.configuration().get("servers", JsonNode.class).map(StyxServerComponents::readComponents).orElse((Map)ImmutableMap.of()).forEach((name, definition) -> {
            LOGGER.warn("Loading styx server: " + name + ": " + definition);
            InetServer provider = Builtins.buildServer(name, definition, this.serverObjectStore, Builtins.BUILTIN_SERVER_FACTORIES, this.routingObjectContext);
            StyxObjectRecord<InetServer> record = new StyxObjectRecord<InetServer>(definition.type(), (Set<String>)ImmutableSet.copyOf(definition.tags()), definition.config(), provider);
            this.serverObjectStore.insert((String)name, record);
        });
    }

    private static Map<String, StyxObjectDefinition> readComponents(JsonNode root) {
        HashMap<String, StyxObjectDefinition> handlers = new HashMap<String, StyxObjectDefinition>();
        root.fields().forEachRemaining(entry -> {
            String name = (String)entry.getKey();
            StyxObjectDefinition handlerDef = new JsonNodeConfig((JsonNode)entry.getValue()).as(StyxObjectDefinition.class);
            handlers.put(name, handlerDef);
        });
        return handlers;
    }

    public Environment environment() {
        return this.environment;
    }

    public Map<String, StyxService> services() {
        return this.services;
    }

    public List<NamedPlugin> plugins() {
        return this.plugins;
    }

    public StyxObjectStore<RoutingObjectRecord> routeDatabase() {
        return this.routeObjectStore;
    }

    public StyxObjectStore<StyxObjectRecord<StyxService>> servicesDatabase() {
        return this.providerObjectStore;
    }

    public StyxObjectStore<StyxObjectRecord<NettyExecutor>> executors() {
        return this.executorObjectStore;
    }

    public StyxObjectStore<StyxObjectRecord<InetServer>> serversDatabase() {
        return this.serverObjectStore;
    }

    public RoutingObjectFactory.Context routingObjectFactoryContext() {
        return this.routingObjectContext;
    }

    public NettyExecutor clientExecutor() {
        return this.executor;
    }

    public StartupConfig startupConfig() {
        return this.startupConfig;
    }

    private static Environment newEnvironment(StyxConfig config, MetricRegistry metricRegistry) {
        SanitisedHttpHeaderFormatter headerFormatter = new SanitisedHttpHeaderFormatter(config.get("request-logging.hideHeaders", List.class).orElse(Collections.emptyList()), config.get("request-logging.hideCookies", List.class).orElse(Collections.emptyList()));
        SanitisedHttpMessageFormatter sanitisedHttpMessageFormatter = new SanitisedHttpMessageFormatter(headerFormatter);
        return new Environment.Builder().configuration(config).metricRegistry(metricRegistry).buildInfo(StyxServerComponents.readBuildInfo()).eventBus((EventBus)new AsyncEventBus("styx", (Executor)Executors.newSingleThreadExecutor())).httpMessageFormatter((HttpMessageFormatter)sanitisedHttpMessageFormatter).build();
    }

    private static Version readBuildInfo() {
        return Version.readVersionFrom("/version.json");
    }

    private static Map<String, StyxService> mergeServices(Map<String, StyxService> configServices, Map<String, StyxService> additionalServices) {
        if (additionalServices == null) {
            return configServices;
        }
        return new ImmutableMap.Builder().putAll(configServices).putAll(additionalServices).build();
    }

    public static interface LoggingSetUp {
        public static final LoggingSetUp DO_NOT_MODIFY = environment -> {};

        public void setUp(Environment var1);
    }

    public static final class Builder {
        private StyxConfig styxConfig;
        private LoggingSetUp loggingSetUp = LoggingSetUp.DO_NOT_MODIFY;
        private List<ConfiguredPluginFactory> configuredPluginFactories = ImmutableList.of();
        private ServicesLoader servicesLoader = ServicesLoader.SERVICES_FROM_CONFIG;
        private MetricRegistry metricRegistry = new CodaHaleMetricRegistry();
        private StartupConfig startupConfig;
        private final Map<String, RoutingObjectFactory> additionalRoutingObjectFactories = new HashMap<String, RoutingObjectFactory>();
        private final Map<String, StyxService> additionalServices = new HashMap<String, StyxService>();

        public Builder styxConfig(StyxConfig styxConfig) {
            this.styxConfig = Objects.requireNonNull(styxConfig);
            return this;
        }

        public Builder metricsRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = Objects.requireNonNull(metricRegistry);
            return this;
        }

        public Builder configuration(Configuration configuration) {
            return this.styxConfig(new StyxConfig(configuration));
        }

        public Builder loggingSetUp(LoggingSetUp loggingSetUp) {
            this.loggingSetUp = Objects.requireNonNull(loggingSetUp);
            return this;
        }

        @VisibleForTesting
        public Builder loggingSetUp(String logConfigLocation) {
            this.loggingSetUp = env -> LOGBackConfigurer.initLogging(logConfigLocation, true);
            return this;
        }

        @VisibleForTesting
        public Builder plugins(Map<String, Plugin> plugins) {
            return this.pluginFactories(Builder.stubFactories(plugins));
        }

        private static List<ConfiguredPluginFactory> stubFactories(Map<String, Plugin> plugins) {
            return plugins.entrySet().stream().map(entry -> {
                String name = (String)entry.getKey();
                Plugin plugin = (Plugin)entry.getValue();
                return new ConfiguredPluginFactory(name, any -> plugin);
            }).collect(Collectors.toList());
        }

        public Builder pluginFactories(List<ConfiguredPluginFactory> configuredPluginFactories) {
            this.configuredPluginFactories = Objects.requireNonNull(configuredPluginFactories);
            return this;
        }

        @VisibleForTesting
        Builder services(ServicesLoader servicesLoader) {
            this.servicesLoader = Objects.requireNonNull(servicesLoader);
            return this;
        }

        @VisibleForTesting
        public Builder additionalServices(Map<String, StyxService> services) {
            this.additionalServices.putAll(services);
            return this;
        }

        public Builder startupConfig(StartupConfig startupConfig) {
            this.startupConfig = startupConfig;
            return this;
        }

        @VisibleForTesting
        public Builder additionalRoutingObjects(Map<String, RoutingObjectFactory> additionalRoutingObjectFactories) {
            this.additionalRoutingObjectFactories.putAll(additionalRoutingObjectFactories);
            return this;
        }

        public StyxServerComponents build() {
            return new StyxServerComponents(this);
        }
    }
}

