/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup.extensions;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.styx.api.plugins.spi.PluginFactory;
import java.util.Objects;
import java.util.function.Function;

public class ConfiguredPluginFactory {
    private final String name;
    private final PluginFactory pluginFactory;
    private final Function<Class<?>, Object> configProvider;

    public ConfiguredPluginFactory(String name, PluginFactory pluginFactory, Function<Class<?>, Object> configProvider) {
        this.name = Objects.requireNonNull(name);
        this.pluginFactory = Objects.requireNonNull(pluginFactory);
        this.configProvider = Objects.requireNonNull(configProvider);
    }

    public ConfiguredPluginFactory(String name, PluginFactory pluginFactory) {
        this(name, pluginFactory, (Class<?> any) -> null);
    }

    @VisibleForTesting
    public ConfiguredPluginFactory(String name, PluginFactory pluginFactory, Object pluginConfig) {
        this(name, pluginFactory, (Class<?> type) -> type.cast(pluginConfig));
    }

    public String name() {
        return this.name;
    }

    PluginFactory pluginFactory() {
        return this.pluginFactory;
    }

    <T> T pluginConfig(Class<T> clazz) {
        return (T)this.configProvider.apply(clazz);
    }
}

