/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup.extensions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.plugins.spi.Plugin;
import com.hotels.styx.api.plugins.spi.PluginFactory;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoPlugin
implements Plugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemoPlugin.class);
    private final DemoConfig config;

    private DemoPlugin(DemoConfig config) {
        this.config = Objects.requireNonNull(config);
        LOGGER.info("Demo plugin constructed");
    }

    public Eventual<LiveHttpResponse> intercept(LiveHttpRequest request, HttpInterceptor.Chain chain) {
        LOGGER.info("Demo plugin propagating request down the chain");
        return chain.proceed(request).map(response -> {
            LOGGER.info("Demo plugin has propagating response from the chain");
            return response.newBuilder().header((CharSequence)"Demo-Plugin", (Object)this.config.responseHeaderValue).build();
        });
    }

    public Map<String, HttpHandler> adminInterfaceHandlers() {
        return ImmutableMap.of((Object)"example", (Object)this.adminHandler());
    }

    private HttpHandler adminHandler() {
        return (request, context) -> {
            LOGGER.info("Demo plugin serving admin page");
            return Eventual.of((Object)HttpResponse.response().header(HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8).body("This is an admin page provided by a demo plugin used to test Styx's plugin functionality. Text from config=" + this.config.adminText, StandardCharsets.UTF_8).build().stream());
        };
    }

    public static class DemoConfig {
        private final String adminText;
        private final String responseHeaderValue;

        @JsonCreator
        public DemoConfig(@JsonProperty(value="adminText") String adminText, @JsonProperty(value="responseHeaderValue") String responseHeaderValue) {
            this.adminText = adminText;
            this.responseHeaderValue = responseHeaderValue;
        }
    }

    public static class Factory
    implements PluginFactory {
        public Plugin create(PluginFactory.Environment environment) {
            return new DemoPlugin((DemoConfig)environment.pluginConfig(DemoConfig.class));
        }
    }
}

