/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup.extensions;

import com.hotels.styx.common.FailureHandlingStrategy;
import com.hotels.styx.common.MapStream;
import com.hotels.styx.common.Pair;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.proxy.plugin.PluginStartupException;
import com.hotels.styx.spi.config.SpiExtension;
import com.hotels.styx.startup.extensions.ConfiguredPluginFactory;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FailureHandling {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailureHandling.class);
    static final FailureHandlingStrategy<Pair<String, SpiExtension>, ConfiguredPluginFactory> PLUGIN_FACTORY_LOADING_FAILURE_HANDLING_STRATEGY = new FailureHandlingStrategy.Builder().doImmediatelyOnEachFailure((plugin, err) -> LOGGER.error(String.format("Could not load plugin: pluginName=%s; factoryClass=%s", plugin.key(), ((SpiExtension)plugin.value()).factory().factoryClass()), (Throwable)err)).doOnFailuresAfterAllProcessing(failures -> {
        throw new PluginStartupException(FailureHandling.afterFailuresErrorMessage(failures, Pair::key));
    }).build();
    static final FailureHandlingStrategy<ConfiguredPluginFactory, NamedPlugin> PLUGIN_STARTUP_FAILURE_HANDLING_STRATEGY = new FailureHandlingStrategy.Builder().doImmediatelyOnEachFailure((plugin, err) -> LOGGER.error(String.format("Could not load plugin: pluginName=%s; factoryClass=%s", plugin.name(), plugin.pluginFactory().getClass().getName()), (Throwable)err)).doOnFailuresAfterAllProcessing(failures -> {
        throw new PluginStartupException(FailureHandling.afterFailuresErrorMessage(failures, ConfiguredPluginFactory::name));
    }).build();

    private FailureHandling() {
    }

    private static <K> String afterFailuresErrorMessage(Map<K, Exception> failures, Function<K, String> getPluginName) {
        List<String> failedPlugins = FailureHandling.mapKeys(failures, getPluginName);
        List<String> causes = FailureHandling.mapEntries(failures, (key, err) -> String.format("%s: %s", getPluginName.apply(key), err));
        return String.format("%s plugin(s) could not be loaded: failedPlugins=%s; failureCauses=%s", failures.size(), failedPlugins, causes);
    }

    private static <R, K, V> List<R> mapKeys(Map<K, V> map2, Function<K, R> function) {
        return MapStream.stream(map2).mapToObject((k, v) -> function.apply(k)).collect(Collectors.toList());
    }

    private static <R, K, V> List<R> mapEntries(Map<K, V> map2, BiFunction<K, V, R> function) {
        return MapStream.stream(map2).mapToObject(function).collect(Collectors.toList());
    }
}

