/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.startup.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotels.styx.Environment;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.api.configuration.Configuration;
import com.hotels.styx.api.plugins.spi.Plugin;
import com.hotels.styx.api.plugins.spi.PluginFactory;
import com.hotels.styx.common.Pair;
import com.hotels.styx.proxy.plugin.FileSystemPluginFactoryLoader;
import com.hotels.styx.proxy.plugin.NamedPlugin;
import com.hotels.styx.proxy.plugin.PluginsMetadata;
import com.hotels.styx.spi.config.SpiExtension;
import com.hotels.styx.startup.extensions.ConfiguredPluginFactory;
import com.hotels.styx.startup.extensions.FailureHandling;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginLoadingForStartup {
    private static final String DEFAULT_PLUGINS_METRICS_SCOPE = "styx.plugins";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLoadingForStartup.class);

    private PluginLoadingForStartup() {
    }

    public static List<NamedPlugin> loadPlugins(Environment environment, List<ConfiguredPluginFactory> factories) {
        return PluginLoadingForStartup.loadPluginsFromFactories(environment, factories);
    }

    public static List<NamedPlugin> loadPlugins(Environment environment) {
        List<ConfiguredPluginFactory> activePlugins = PluginLoadingForStartup.loadFactoriesFromConfig(environment);
        return PluginLoadingForStartup.loadPluginsFromFactories(environment, activePlugins);
    }

    private static List<ConfiguredPluginFactory> loadFactoriesFromConfig(Environment environment) {
        return environment.configuration().get("plugins", PluginsMetadata.class).map(plugins -> {
            if (environment.configuration().get("httpPipeline", JsonNode.class).isPresent()) {
                return plugins.plugins();
            }
            return plugins.activePlugins();
        }).map(inputs -> FailureHandling.PLUGIN_FACTORY_LOADING_FAILURE_HANDLING_STRATEGY.process(inputs, PluginLoadingForStartup::loadPluginFactory)).orElse(Collections.emptyList());
    }

    private static ConfiguredPluginFactory loadPluginFactory(Pair<String, SpiExtension> pair) {
        String pluginName = (String)pair.key();
        SpiExtension spiExtension = (SpiExtension)pair.value();
        PluginFactory factory = new FileSystemPluginFactoryLoader().load(spiExtension);
        return new ConfiguredPluginFactory(pluginName, factory, spiExtension::config);
    }

    private static List<NamedPlugin> loadPluginsFromFactories(Environment environment, List<ConfiguredPluginFactory> factories) {
        return FailureHandling.PLUGIN_STARTUP_FAILURE_HANDLING_STRATEGY.process(factories, factory -> {
            LOGGER.info("Instantiating Plugin, pluginName={}...", (Object)factory.name());
            NamedPlugin plugin = PluginLoadingForStartup.loadPlugin(environment, factory);
            LOGGER.info("Instantiated Plugin, pluginName={}", (Object)factory.name());
            return plugin;
        });
    }

    private static NamedPlugin loadPlugin(final Environment environment, final ConfiguredPluginFactory factory) {
        PluginFactory.Environment pluginEnvironment = new PluginFactory.Environment(){

            public <T> T pluginConfig(Class<T> clazz) {
                return factory.pluginConfig(clazz);
            }

            public Configuration configuration() {
                return environment.configuration();
            }

            public MetricRegistry metricRegistry() {
                return environment.metricRegistry().scope("styx.plugins." + factory.name());
            }
        };
        Plugin plugin = factory.pluginFactory().create(pluginEnvironment);
        return NamedPlugin.namedPlugin(factory.name(), plugin);
    }
}

