/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server;

import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.server.HttpErrorStatusListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

class CompositeHttpErrorStatusListener
implements HttpErrorStatusListener {
    private final List<HttpErrorStatusListener> listeners;

    public CompositeHttpErrorStatusListener(List<HttpErrorStatusListener> listeners) {
        this.listeners = new ArrayList<HttpErrorStatusListener>(listeners);
    }

    @Override
    public void proxyErrorOccurred(Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(cause));
    }

    @Override
    public void proxyWriteFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyWriteFailure(request, response, cause));
    }

    @Override
    public void proxyingFailure(LiveHttpRequest request, LiveHttpResponse response, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyingFailure(request, response, cause));
    }

    @Override
    public void proxyErrorOccurred(HttpResponseStatus status, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(status, cause));
    }

    @Override
    public void proxyErrorOccurred(LiveHttpRequest request, InetSocketAddress clientAddress, HttpResponseStatus status, Throwable cause) {
        this.listeners.forEach(listener -> listener.proxyErrorOccurred(request, clientAddress, status, cause));
    }
}

