/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.collect.ImmutableList;
import com.hotels.styx.common.Strings;
import com.hotels.styx.common.io.ResourceFactory;
import com.hotels.styx.server.HttpConnectorConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@JsonDeserialize(builder=Builder.class)
public final class HttpsConnectorConfig
extends HttpConnectorConfig {
    private final String sslProvider;
    private final String certificateFile;
    private final String certificateKeyFile;
    private final List<String> cipherSuites;
    private final long sessionTimeoutMillis;
    private final long sessionCacheSize;
    private final List<String> protocols;

    private HttpsConnectorConfig(Builder builder) {
        super(builder.port);
        this.sslProvider = builder.sslProvider;
        this.certificateFile = builder.certificateFile;
        this.certificateKeyFile = builder.certificateKeyFile;
        this.cipherSuites = builder.cipherSuites;
        this.sessionTimeoutMillis = builder.sessionTimeoutMillis;
        this.sessionCacheSize = builder.sessionCacheSize;
        this.protocols = builder.protocols;
    }

    @Override
    public String type() {
        return "https";
    }

    public String sslProvider() {
        return this.sslProvider;
    }

    public String certificateFile() {
        return this.certificateFile;
    }

    public String certificateKeyFile() {
        return this.certificateKeyFile;
    }

    public List<String> ciphers() {
        return this.cipherSuites;
    }

    public long sessionTimeoutMillis() {
        return this.sessionTimeoutMillis;
    }

    public long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    public List<String> protocols() {
        return this.protocols;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.sslProvider, this.certificateFile, this.certificateKeyFile, this.sessionTimeoutMillis, this.sessionCacheSize, this.protocols);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HttpsConnectorConfig other = (HttpsConnectorConfig)obj;
        return Objects.equals(this.sslProvider, other.sslProvider) && Objects.equals(this.certificateFile, other.certificateFile) && Objects.equals(this.certificateKeyFile, other.certificateKeyFile) && Objects.equals(this.sessionTimeoutMillis, other.sessionTimeoutMillis) && Objects.equals(this.sessionCacheSize, other.sessionCacheSize) && Objects.equals(this.protocols, other.protocols);
    }

    @Override
    public String toString() {
        return new StringBuilder(256).append(this.getClass().getSimpleName()).append("{port=").append(this.port()).append(", sslProvider=").append(this.sslProvider).append(", certificateFile=").append(this.certificateFile).append(", certificateKeyFile=").append(this.certificateKeyFile).append(", sessionTimeoutMillis=").append(this.sessionTimeoutMillis).append(", sessionCacheSize=").append(this.sessionCacheSize).append(", cipherSuites=").append(this.cipherSuites).append(", protocols=").append(this.protocols != null ? this.protocols.stream().filter(Objects::nonNull).collect(Collectors.joining(",")) : "None").append('}').toString();
    }

    public boolean isConfigured() {
        return Strings.isNotEmpty((String)this.certificateFile) && Strings.isNotEmpty((String)this.certificateKeyFile);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private int port;
        private String sslProvider = "JDK";
        private String certificateFile;
        private String certificateKeyFile;
        private long sessionTimeoutMillis = 300000L;
        private long sessionCacheSize;
        private List<String> cipherSuites = Collections.emptyList();
        private List<String> protocols = Collections.emptyList();

        @JsonProperty(value="port")
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder sslProvider(String sslProvider) {
            this.sslProvider = Objects.requireNonNull(sslProvider);
            return this;
        }

        public Builder certificateFile(String certificateFile) {
            this.certificateFile = ResourceFactory.newResource((String)certificateFile).absolutePath();
            return this;
        }

        public Builder certificateKeyFile(String certificateKeyFile) {
            this.certificateKeyFile = ResourceFactory.newResource((String)certificateKeyFile).absolutePath();
            return this;
        }

        public Builder cipherSuites(List<String> cipherSuites) {
            this.cipherSuites = ImmutableList.copyOf((Collection)Objects.requireNonNull(cipherSuites));
            return this;
        }

        public Builder sessionTimeout(long sessionTimeout, TimeUnit timeUnit) {
            this.sessionTimeoutMillis = timeUnit.toMillis(sessionTimeout);
            return this;
        }

        public Builder sessionCacheSize(long sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public Builder protocols(String ... protocols) {
            this.protocols = ImmutableList.copyOf((Object[])protocols);
            return this;
        }

        public HttpsConnectorConfig build() {
            return new HttpsConnectorConfig(this);
        }
    }
}

