/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server;

import com.hotels.styx.common.Preconditions;
import com.hotels.styx.server.DuplicatePathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTrie<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathTrie.class);
    private final MatchTree<T> tree = new MatchTree();

    public void put(String path, T value) {
        T existing;
        Preconditions.checkNotEmpty((String)path);
        Objects.requireNonNull(value);
        List<String> components = this.pathToComponents(Paths.get(this.removeAsterisk(path), new String[0]));
        if (path.endsWith("/") || path.endsWith("/*")) {
            components.add("/");
        }
        if ((existing = this.tree.getExactMatch(components)) != null) {
            String message = String.format("Path '%s' has already been configured with a ID of [%s]", path, existing.toString());
            throw new DuplicatePathException(message);
        }
        this.tree.addValueWithParents(components, value);
    }

    public Optional<T> get(String path) {
        T value;
        List<String> components = this.getPathComponents(path);
        MatchTreeNode<T> node = this.tree.getLongestMatchingNode(components);
        if (node == null) {
            return Optional.empty();
        }
        if (this.isExactlyMatchingPath(node, path, components)) {
            value = node.value();
            if (value == null) {
                value = this.bestValue(node.parent());
            }
        } else {
            value = this.bestValue(node);
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public T remove(String path) {
        List<String> components = this.getPathComponents(path);
        MatchTreeNode<T> node = this.tree.getLongestMatchingNode(components);
        T t = this.bestValue(node);
        if (node != null) {
            node.delete();
        }
        return t;
    }

    private List<String> getPathComponents(String path) {
        if (path.length() == 0) {
            return new ArrayList<String>();
        }
        if (path.charAt(0) == '/') {
            return Arrays.asList(path.substring(1).split("/"));
        }
        return Arrays.asList(path.split("/"));
    }

    private T bestValue(MatchTreeNode<T> node) {
        T value = null;
        if (node != null) {
            value = node.child("/") != null ? (T)node.child("/").value() : (T)this.bestValue(node.parent());
        }
        return value;
    }

    private boolean isExactlyMatchingPath(MatchTreeNode<T> node, String path, List<String> components) {
        boolean exactlyMatching = false;
        if (node.level() == components.size() && this.lastName(components).equals(node.name()) && !path.endsWith("/") && !path.endsWith("/*")) {
            exactlyMatching = true;
        }
        return exactlyMatching;
    }

    private String lastName(List<String> components) {
        int size = components.size();
        return size > 0 ? components.get(size - 1) : "";
    }

    private List<String> pathToComponents(Path path) {
        LinkedList<String> components = new LinkedList<String>();
        for (int i = 0; i < path.getNameCount(); ++i) {
            String name = path.getName(i).toString();
            components.add(name);
        }
        return components;
    }

    private String removeAsterisk(String path) {
        String newPath = path;
        if (path.endsWith("/*")) {
            newPath = path.substring(0, path.length() - 1);
        }
        return newPath;
    }

    public void printContent() {
        String text = this.tree.printTree();
        LOGGER.debug(text);
    }

    private static class MatchTreeNode<T> {
        private final String name;
        private final Map<String, MatchTreeNode<T>> children;
        private final MatchTreeNode<T> parent;
        private final int level;
        private T value;

        MatchTreeNode(String name, MatchTreeNode<T> parent) {
            this.name = name;
            this.children = new HashMap<String, MatchTreeNode<T>>();
            this.value = null;
            this.parent = parent;
            this.level = parent == null ? 0 : parent.level() + 1;
        }

        public MatchTreeNode<T> child(String name) {
            return this.children.get(name);
        }

        public MatchTreeNode<T> newChild(String name) {
            if (this.children.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Duplicate child name in node '%s'.", this.name));
            }
            MatchTreeNode<T> childNode = new MatchTreeNode<T>(name, this);
            this.children.put(name, childNode);
            return childNode;
        }

        public T value() {
            return this.value;
        }

        public void value(T value) {
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public List<String> children() {
            return new LinkedList<String>(this.children.keySet());
        }

        public MatchTreeNode<T> parent() {
            return this.parent;
        }

        public int level() {
            return this.level;
        }

        public void delete() {
            if (this.parent != null) {
                this.parent.children.remove(this.name);
            }
        }
    }

    private static class MatchTree<T> {
        private final MatchTreeNode<T> root = new MatchTreeNode("/", null);

        MatchTree() {
        }

        public void addValueWithParents(List<String> path, T value) {
            MatchTreeNode<T> node = this.root;
            for (String name : path) {
                MatchTreeNode<T> child = node.child(name);
                if (child == null) {
                    child = node.newChild(name);
                }
                node = child;
            }
            node.value(value);
        }

        public T getExactMatch(List<String> path) {
            String name;
            MatchTreeNode<T> node = this.root;
            Iterator<String> iterator = path.iterator();
            while (iterator.hasNext() && (node = node.child(name = iterator.next())) != null) {
            }
            return node != null ? (T)node.value() : null;
        }

        public MatchTreeNode<T> getLongestMatchingNode(List<String> path) {
            String name;
            MatchTreeNode<T> child;
            MatchTreeNode<T> node = this.root;
            Iterator<String> iterator = path.iterator();
            while (iterator.hasNext() && (child = node.child(name = iterator.next())) != null) {
                node = child;
            }
            return node;
        }

        public String printTree() {
            MatchTreeNode<T> node = this.root;
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            this.printTreeInternal(node, 0, sb);
            return sb.toString();
        }

        private String printTreeInternal(MatchTreeNode<T> node, int level, StringBuilder sb) {
            sb.append(this.getIndent(level));
            sb.append(String.format("%s: %s\n", node.name(), node.value() == null ? "null" : node.value().toString()));
            for (String name : node.children()) {
                MatchTreeNode<T> child = node.child(name);
                this.printTreeInternal(child, level + 1, sb);
            }
            return sb.toString();
        }

        private String getIndent(int level) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                sb.append("  ");
            }
            return sb.toString();
        }
    }
}

