/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.server.RequestProgressListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RequestStatsCollector
implements RequestProgressListener {
    private final Counter outstandingRequests;
    private final Timer latencyTimer;
    private final Counter[] httpResponseStatusClassCounters = new Counter[6];
    private final Map<Integer, Counter> httpServerErrorResponseCounters = new HashMap<Integer, Counter>(6);
    private final Meter requestsIncoming;
    private final Meter responseErrorRate;
    private final Counter responsesSent;
    private final ConcurrentHashMap<Object, Long> ongoingRequests = new ConcurrentHashMap();
    private final NanoClock nanoClock;

    public RequestStatsCollector(MetricRegistry metrics) {
        this(metrics, NanoClock.SYSTEM_CLOCK);
    }

    RequestStatsCollector(MetricRegistry metrics, NanoClock nanoClock) {
        this.nanoClock = nanoClock;
        this.outstandingRequests = metrics.counter("outstanding");
        this.latencyTimer = metrics.timer("latency");
        this.requestsIncoming = metrics.meter("received");
        this.responseErrorRate = metrics.meter("error-rate.500");
        this.responsesSent = metrics.counter("response.sent");
        this.httpResponseStatusClassCounters[0] = metrics.counter(this.responseCountName("status.unrecognised"));
        this.httpResponseStatusClassCounters[1] = metrics.counter(this.responseCountName("status.1xx"));
        this.httpResponseStatusClassCounters[2] = metrics.counter(this.responseCountName("status.2xx"));
        this.httpResponseStatusClassCounters[3] = metrics.counter(this.responseCountName("status.3xx"));
        this.httpResponseStatusClassCounters[4] = metrics.counter(this.responseCountName("status.4xx"));
        this.httpResponseStatusClassCounters[5] = metrics.counter(this.responseCountName("status.5xx"));
        for (int code : Arrays.asList(500, 501, 502, 503, 504, 521)) {
            Counter counter = metrics.counter(this.responseCountNameForStatus(code));
            this.httpServerErrorResponseCounters.put(code, counter);
        }
    }

    @Override
    public void onRequest(Object requestId) {
        Long previous = this.ongoingRequests.putIfAbsent(requestId, this.nanoClock.nanoTime());
        if (previous == null) {
            this.outstandingRequests.inc();
            this.requestsIncoming.mark();
        }
    }

    @Override
    public void onComplete(Object requestId, int responseStatus) {
        Long startTime = this.ongoingRequests.remove(requestId);
        if (startTime != null) {
            this.updateResponseStatusCounter(responseStatus);
            this.responsesSent.inc();
            this.outstandingRequests.dec();
            this.latencyTimer.update(this.nanoClock.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void onTerminate(Object requestId) {
        Long startTime = this.ongoingRequests.remove(requestId);
        if (startTime != null) {
            this.outstandingRequests.dec();
            this.latencyTimer.update(this.nanoClock.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    private void updateResponseStatusCounter(int code) {
        if (this.isServerError(this.httpStatusCodeClass(code))) {
            if (code == 500) {
                this.responseErrorRate.mark();
            }
            this.updateServerErrorCount(code);
        }
        this.updateStatusCodeClassCounter(this.httpStatusCodeClass(code));
    }

    private void updateServerErrorCount(int code) {
        Counter counter = this.httpServerErrorResponseCounters.get(code);
        if (counter != null) {
            counter.inc();
        }
    }

    private void updateStatusCodeClassCounter(int statusCodeClass) {
        this.httpResponseStatusClassCounters[statusCodeClass].inc();
    }

    private boolean isServerError(int statusCodeClass) {
        return statusCodeClass == 5;
    }

    private String responseCountName(String counterName) {
        return "response." + counterName;
    }

    private String responseCountNameForStatus(int code) {
        return this.responseCountName("status." + String.valueOf(code));
    }

    private int httpStatusCodeClass(int code) {
        if (code < 100 || code >= 600) {
            return 0;
        }
        return code / 100;
    }

    static interface NanoClock {
        public static final NanoClock SYSTEM_CLOCK = System::nanoTime;

        public long nanoTime();
    }
}

