/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.handlers;

import com.google.common.io.ByteStreams;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpRequest;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.common.http.handler.BaseHttpHandler;
import com.hotels.styx.server.handlers.MediaTypes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassPathResourceHandler
extends BaseHttpHandler {
    private static final Pattern DOUBLE_SEPARATOR = Pattern.compile("//", 16);
    private final String requestPrefix;
    private final String resourceRoot;

    public ClassPathResourceHandler(String resourceRoot) {
        this(resourceRoot, resourceRoot);
    }

    public ClassPathResourceHandler(String requestPrefix, String resourceRoot) {
        this.requestPrefix = ClassPathResourceHandler.checkPrefix(requestPrefix);
        this.resourceRoot = ClassPathResourceHandler.ensureHasTrailingSlash(resourceRoot);
    }

    private static String checkPrefix(String requestPrefix) {
        Objects.requireNonNull(requestPrefix);
        if (requestPrefix.isEmpty()) {
            throw new IllegalArgumentException("Request prefix is empty.");
        }
        if (!requestPrefix.startsWith("/")) {
            throw new IllegalArgumentException("Request prefix must start with '/'");
        }
        return ClassPathResourceHandler.ensureHasTrailingSlash(requestPrefix);
    }

    protected HttpResponse doHandle(HttpRequest request, HttpInterceptor.Context context) {
        try {
            String path = request.path();
            if (!path.startsWith(this.requestPrefix) || path.contains("..")) {
                return ClassPathResourceHandler.error(HttpResponseStatus.FORBIDDEN);
            }
            String resourcePath = DOUBLE_SEPARATOR.matcher(this.resourceRoot + ClassPathResourceHandler.ensureHasPreceedingSlash(request.path().replace(this.requestPrefix, ""))).replaceAll(Matcher.quoteReplacement("/"));
            return new HttpResponse.Builder(HttpResponseStatus.OK).body(ClassPathResourceHandler.resourceBody(resourcePath), true).header(HttpHeaderNames.CONTENT_TYPE, (Object)MediaTypes.mediaTypeOf(path)).build();
        }
        catch (FileNotFoundException e) {
            return ClassPathResourceHandler.error(HttpResponseStatus.NOT_FOUND);
        }
        catch (IOException e) {
            return ClassPathResourceHandler.error(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static String ensureHasTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private static String ensureHasPreceedingSlash(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private static byte[] resourceBody(String path) throws IOException {
        try (InputStream stream = ClassPathResourceHandler.classPathResourceAsStream(path);){
            byte[] byArray = ClassPathResourceHandler.readStream(stream);
            return byArray;
        }
    }

    private static HttpResponse error(HttpResponseStatus status) {
        return new HttpResponse.Builder(status).body(status.description(), StandardCharsets.UTF_8).build();
    }

    private static InputStream classPathResourceAsStream(String resource) throws FileNotFoundException {
        InputStream stream = ClassPathResourceHandler.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        return stream;
    }

    private static byte[] readStream(InputStream stream) throws IOException {
        return ByteStreams.toByteArray((InputStream)stream);
    }
}

