/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.handlers;

import com.google.common.net.MediaType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class MediaTypes {
    public static final MediaType MICROSOFT_MS_VIDEO = MediaType.create((String)"video", (String)"x-msvideo");
    public static final MediaType MICROSOFT_ASF_VIDEO = MediaType.create((String)"video", (String)"x-ms-asf");
    public static final MediaType WAV_AUDIO = MediaType.create((String)"audio", (String)"x-wav");
    public static final MediaType ICON = MediaType.create((String)"image", (String)"x-icon");
    public static final MediaType EVENT_STREAM = MediaType.create((String)"text", (String)"event-stream");
    private static final Map<String, MediaType> MEDIA_TYPES_BY_EXTENSION = new HashMap<String, MediaType>();

    private MediaTypes() {
    }

    private static void addMediaType(MediaType mediaType, String ... extensions) {
        for (String extension : extensions) {
            MEDIA_TYPES_BY_EXTENSION.put(extension, mediaType);
        }
    }

    public static MediaType mediaTypeForExtension(String extension) {
        return Optional.ofNullable(MEDIA_TYPES_BY_EXTENSION.get(extension)).orElse(MediaType.OCTET_STREAM);
    }

    public static MediaType mediaTypeOf(String filename) {
        int dotPosition = filename.lastIndexOf(46);
        if (dotPosition > 0) {
            return MediaTypes.mediaTypeForExtension(filename.substring(dotPosition + 1));
        }
        return MediaType.OCTET_STREAM;
    }

    static {
        MediaTypes.addMediaType(MediaType.PLAIN_TEXT_UTF_8, "txt");
        MediaTypes.addMediaType(MediaType.HTML_UTF_8, "html", "htm");
        MediaTypes.addMediaType(MediaType.CSS_UTF_8, "css");
        MediaTypes.addMediaType(MediaType.JAVASCRIPT_UTF_8, "js");
        MediaTypes.addMediaType(ICON, "ico");
        MediaTypes.addMediaType(MediaType.GIF, "gif");
        MediaTypes.addMediaType(MediaType.JPEG, "jpg", "jpeg");
        MediaTypes.addMediaType(MediaType.PNG, "png");
        MediaTypes.addMediaType(MediaType.MICROSOFT_EXCEL, "xls");
        MediaTypes.addMediaType(MediaType.PDF, "pdf");
        MediaTypes.addMediaType(MediaType.MPEG_AUDIO, "mp3");
        MediaTypes.addMediaType(WAV_AUDIO, "wav");
        MediaTypes.addMediaType(MICROSOFT_ASF_VIDEO, "asf");
        MediaTypes.addMediaType(MICROSOFT_MS_VIDEO, "avi");
        MediaTypes.addMediaType(MediaType.MPEG_VIDEO, "mpg");
    }
}

