/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.handlers;

import com.google.common.io.Files;
import com.google.common.net.MediaType;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.common.http.handler.HttpAggregator;
import com.hotels.styx.common.http.handler.NotFoundHandler;
import com.hotels.styx.server.handlers.MediaTypes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFileHandler.class);
    private final File dir;

    public StaticFileHandler(File dir) {
        this.dir = dir;
    }

    public Eventual<LiveHttpResponse> handle(LiveHttpRequest request, HttpInterceptor.Context context) {
        try {
            return this.resolveFile(request.path()).map(x$0 -> new ResolvedFile((File)x$0)).map(resolvedFile -> HttpResponse.response().addHeader(HttpHeaderNames.CONTENT_TYPE, (Object)((ResolvedFile)resolvedFile).mediaType).body(((ResolvedFile)resolvedFile).content, StandardCharsets.UTF_8).build().stream()).map(Eventual::of).orElseGet(() -> new HttpAggregator(NotFoundHandler.NOT_FOUND_HANDLER).handle(request, context));
        }
        catch (IOException e) {
            return Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR).build().stream());
        }
    }

    private static String readLines(File file) {
        try {
            return Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<File> resolveFile(String path) throws IOException {
        File result = new File(this.dir, path).getCanonicalFile();
        LOG.debug("Resolved path={}", (Object)result);
        if (!result.exists()) {
            return Optional.empty();
        }
        String fullPath = result.getPath();
        if (!fullPath.startsWith(this.dir.getCanonicalPath() + File.separator) && !fullPath.equals(this.dir.getCanonicalPath())) {
            result = null;
        }
        return Optional.ofNullable(result);
    }

    private static class ResolvedFile {
        private final String content;
        private final MediaType mediaType;

        private ResolvedFile(File file) {
            this.content = StaticFileHandler.readLines(file);
            this.mediaType = MediaTypes.mediaTypeOf(file.getName());
        }
    }
}

