/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty;

import com.google.common.collect.ImmutableMap;
import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpResponse;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.extension.service.spi.AbstractStyxService;
import com.hotels.styx.server.netty.NettyServerBuilder;
import com.hotels.styx.server.netty.ServerConnector;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyServer
extends AbstractStyxService
implements InetServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private final ChannelGroup channelGroup;
    private final HttpHandler handler;
    private final ServerConnector serverConnector;
    private final String host;
    private final NettyExecutor bossExecutor;
    private final NettyExecutor workerExecutor;
    private final Runnable shutdownAction;
    private volatile InetSocketAddress address;

    NettyServer(NettyServerBuilder nettyServerBuilder) {
        super("");
        this.host = nettyServerBuilder.host();
        this.channelGroup = Objects.requireNonNull(nettyServerBuilder.channelGroup());
        this.handler = Objects.requireNonNull(nettyServerBuilder.handler());
        this.serverConnector = nettyServerBuilder.protocolConnector();
        this.bossExecutor = nettyServerBuilder.bossExecutor();
        this.workerExecutor = nettyServerBuilder.workerExecutor();
        this.shutdownAction = nettyServerBuilder.shutdownAction();
    }

    public Map<String, HttpHandler> adminInterfaceHandlers(String namespace) {
        return ImmutableMap.of((Object)"port", (request, response) -> Eventual.of((Object)HttpResponse.response((HttpResponseStatus)HttpResponseStatus.OK).disableCaching().body(String.format("%d", this.address.getPort()), StandardCharsets.UTF_8).build().stream()));
    }

    @Override
    public InetSocketAddress inetAddress() {
        return Optional.ofNullable(this.address).map(it -> {
            try {
                return new InetSocketAddress(this.host, it.getPort());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).orElse(null);
    }

    protected CompletableFuture<Void> startService() {
        LOGGER.info("starting services");
        CompletableFuture<Void> serviceFuture = new CompletableFuture<Void>();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossExecutor.eventLoopGroup(), this.workerExecutor.eventLoopGroup()).channel(this.bossExecutor.serverEventLoopClass())).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                NettyServer.this.serverConnector.configure(ch, NettyServer.this.handler);
            }
        });
        int port = this.serverConnector.port();
        b.bind((SocketAddress)new InetSocketAddress(port)).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                this.channelGroup.add((Object)channel);
                this.address = (InetSocketAddress)channel.localAddress();
                LOGGER.info("server connector {} bound successfully on port {} socket port {}", new Object[]{this.serverConnector.getClass(), port, this.address});
                serviceFuture.complete(null);
            } else {
                LOGGER.warn("Failed to start service={} cause={}", (Object)this, (Object)future.cause());
                serviceFuture.completeExceptionally(this.mapToBetterException(future.cause(), port));
            }
        }));
        return serviceFuture;
    }

    protected CompletableFuture<Void> stopService() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.channelGroup.close().awaitUninterruptibly();
                if (this.shutdownAction != null) {
                    this.shutdownAction.run();
                }
                this.address = null;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Throwable mapToBetterException(Throwable cause, int port) {
        if (cause instanceof BindException) {
            return new BindException(String.format("Address [%s] already is use.", port));
        }
        return cause;
    }
}

