/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty;

import com.hotels.styx.InetServer;
import com.hotels.styx.NettyExecutor;
import com.hotels.styx.api.Eventual;
import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.api.HttpResponseStatus;
import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.common.Preconditions;
import com.hotels.styx.server.netty.NettyServer;
import com.hotels.styx.server.netty.ServerConnector;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Objects;
import java.util.Optional;

public final class NettyServerBuilder {
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private static final NettyExecutor DEFAULT_SERVER_BOSS_EXECUTOR = NettyExecutor.create((String)"Server-Boss", (int)1);
    private String host;
    private MetricRegistry metricRegistry;
    private ServerConnector httpConnector;
    private HttpHandler handler = (request, context) -> Eventual.of((Object)LiveHttpResponse.response((HttpResponseStatus)HttpResponseStatus.NOT_FOUND).build());
    private NettyExecutor bossExecutor;
    private NettyExecutor workerExecutor;
    private Runnable shutdownAction = () -> {};

    public static NettyServerBuilder newBuilder() {
        return new NettyServerBuilder();
    }

    String host() {
        return Optional.ofNullable(this.host).orElse("localhost");
    }

    MetricRegistry metricsRegistry() {
        return this.metricRegistry;
    }

    NettyExecutor bossExecutor() {
        return this.bossExecutor;
    }

    NettyExecutor workerExecutor() {
        return this.workerExecutor;
    }

    ChannelGroup channelGroup() {
        return this.channelGroup;
    }

    public Runnable shutdownAction() {
        return this.shutdownAction;
    }

    HttpHandler handler() {
        return this.handler;
    }

    ServerConnector protocolConnector() {
        return this.httpConnector;
    }

    public NettyServerBuilder host(String host) {
        this.host = host;
        return this;
    }

    public NettyServerBuilder setMetricsRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        return this;
    }

    public NettyServerBuilder bossExecutor(NettyExecutor executor) {
        this.bossExecutor = Objects.requireNonNull(executor, "boss executor");
        return this;
    }

    public NettyServerBuilder workerExecutor(NettyExecutor executor) {
        this.workerExecutor = Objects.requireNonNull(executor, "worker executor");
        return this;
    }

    public NettyServerBuilder handler(HttpHandler handler) {
        this.handler = handler;
        return this;
    }

    public NettyServerBuilder setProtocolConnector(ServerConnector connector) {
        this.httpConnector = connector;
        return this;
    }

    public NettyServerBuilder shutdownAction(Runnable shutdownAction) {
        this.shutdownAction = shutdownAction;
        return this;
    }

    public InetServer build() {
        Preconditions.checkArgument((this.httpConnector != null ? 1 : 0) != 0, (Object)"Must configure a protocol connector");
        Preconditions.checkArgument((this.workerExecutor != null ? 1 : 0) != 0, (Object)"Must configure a worker executor");
        if (this.bossExecutor == null) {
            this.bossExecutor = DEFAULT_SERVER_BOSS_EXECUTOR;
        }
        return new NettyServer(this);
    }
}

