/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.HttpConnectorConfig;
import com.hotels.styx.server.HttpsConnectorConfig;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonDeserialize(builder=Builder.class)
public class NettyServerConfig {
    public static final int HALF_OF_AVAILABLE_PROCESSORS = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int bossThreadsCount = 1;
    private int workerThreadsCount = HALF_OF_AVAILABLE_PROCESSORS;
    private int nioAcceptorBacklog = 1024;
    private int maxInitialLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private int requestTimeoutMs = 12000;
    private int keepAliveTimeoutMillis = 12000;
    private int maxConnectionsCount = 512;
    private boolean compressResponses;
    private final Optional<HttpConnectorConfig> httpConnectorConfig;
    private final Optional<HttpsConnectorConfig> httpsConnectorConfig;
    private final Iterable<ConnectorConfig> connectors;

    public NettyServerConfig() {
        this.httpConnectorConfig = Optional.of(new HttpConnectorConfig(8080));
        this.httpsConnectorConfig = Optional.empty();
        this.connectors = Collections.singleton(this.httpConnectorConfig.get());
    }

    protected NettyServerConfig(Builder<?> builder) {
        this.bossThreadsCount = builder.bossThreadsCount;
        this.workerThreadsCount = builder.workerThreadsCount;
        this.nioAcceptorBacklog = builder.nioAcceptorBacklog;
        this.maxInitialLength = builder.maxInitialLength;
        this.maxHeaderSize = builder.maxHeaderSize;
        this.maxChunkSize = builder.maxChunkSize;
        this.requestTimeoutMs = builder.requestTimeoutMs;
        this.keepAliveTimeoutMillis = builder.keepAliveTimeoutMillis;
        this.maxConnectionsCount = builder.maxConnectionsCount;
        this.httpConnectorConfig = Optional.ofNullable(builder.httpConnectorConfig);
        this.httpsConnectorConfig = Optional.ofNullable(builder.httpsConnectorConfig);
        this.compressResponses = builder.compressResponses;
        this.connectors = this.connectorsIterable();
    }

    private Iterable<ConnectorConfig> connectorsIterable() {
        return Stream.of(this.httpConnectorConfig, this.httpsConnectorConfig).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<HttpConnectorConfig> httpConnectorConfig() {
        return this.httpConnectorConfig;
    }

    public Optional<HttpsConnectorConfig> httpsConnectorConfig() {
        return this.httpsConnectorConfig;
    }

    public Iterable<ConnectorConfig> connectors() {
        return this.connectors;
    }

    public int bossThreadsCount() {
        return this.bossThreadsCount;
    }

    public int workerThreadsCount() {
        return this.workerThreadsCount;
    }

    public int nioAcceptorBacklog() {
        return this.nioAcceptorBacklog;
    }

    public int maxInitialLength() {
        return this.maxInitialLength;
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public int requestTimeoutMillis() {
        return this.requestTimeoutMs;
    }

    public int keepAliveTimeoutMillis() {
        return this.keepAliveTimeoutMillis;
    }

    public int maxConnectionsCount() {
        return this.maxConnectionsCount;
    }

    public boolean compressResponses() {
        return this.compressResponses;
    }

    public static class Connectors {
        private final HttpConnectorConfig http;
        private final HttpsConnectorConfig https;

        public Connectors(@JsonProperty(value="http") HttpConnectorConfig http, @JsonProperty(value="https") HttpsConnectorConfig https) {
            this.http = http;
            this.https = https;
        }
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder<T extends Builder<T>> {
        protected int bossThreadsCount = HALF_OF_AVAILABLE_PROCESSORS;
        protected int workerThreadsCount = HALF_OF_AVAILABLE_PROCESSORS;
        protected int nioAcceptorBacklog = 1024;
        protected int maxInitialLength = 4096;
        protected int maxHeaderSize = 8192;
        protected int maxChunkSize = 8192;
        protected int requestTimeoutMs = 12000;
        protected int keepAliveTimeoutMillis = 12000;
        protected int maxConnectionsCount = 512;
        protected HttpConnectorConfig httpConnectorConfig;
        protected HttpsConnectorConfig httpsConnectorConfig;
        protected boolean compressResponses;

        public Builder httpPort(int port) {
            return this.setHttpConnector(new HttpConnectorConfig(port));
        }

        @JsonProperty(value="bossThreadsCount")
        public T setBossThreadsCount(Integer bossThreadsCount) {
            if (bossThreadsCount != null) {
                this.bossThreadsCount = bossThreadsCount;
            }
            return (T)this;
        }

        @JsonProperty(value="workerThreadsCount")
        public T setWorkerThreadsCount(Integer workerThreadsCount) {
            if (workerThreadsCount != null && workerThreadsCount > 0) {
                this.workerThreadsCount = workerThreadsCount;
            }
            return (T)this;
        }

        @JsonProperty(value="nioAcceptorBacklog")
        public T setNioAcceptorBacklog(Integer nioAcceptorBacklog) {
            if (nioAcceptorBacklog != null) {
                this.nioAcceptorBacklog = nioAcceptorBacklog;
            }
            return (T)this;
        }

        @JsonProperty(value="maxInitialLength")
        public T setMaxInitialLength(Integer maxInitialLength) {
            if (maxInitialLength != null) {
                this.maxInitialLength = maxInitialLength;
            }
            return (T)this;
        }

        @JsonProperty(value="maxHeaderSize")
        public T setMaxHeaderSize(Integer maxHeaderSize) {
            if (maxHeaderSize != null) {
                this.maxHeaderSize = maxHeaderSize;
            }
            return (T)this;
        }

        @JsonProperty(value="maxChunkSize")
        public T setMaxChunkSize(Integer maxChunkSize) {
            if (maxChunkSize != null) {
                this.maxChunkSize = maxChunkSize;
            }
            return (T)this;
        }

        @JsonProperty(value="requestTimeoutMillis")
        public T setRequestTimeoutMs(Integer requestTimeoutMs) {
            if (requestTimeoutMs != null) {
                this.requestTimeoutMs = requestTimeoutMs;
            }
            return (T)this;
        }

        @JsonProperty(value="keepAliveTimeoutMillis")
        public T setKeepAliveTimeoutMillis(Integer keepAliveTimeoutMillis) {
            if (keepAliveTimeoutMillis != null) {
                this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
            }
            return (T)this;
        }

        @JsonProperty(value="connectors")
        public T setConnectors(Connectors connectors) {
            this.httpConnectorConfig = connectors.http;
            this.httpsConnectorConfig = connectors.https;
            return (T)this;
        }

        public T setHttpConnector(HttpConnectorConfig httpConnector) {
            this.httpConnectorConfig = httpConnector;
            return (T)this;
        }

        public T setHttpsConnector(HttpsConnectorConfig httpsConnector) {
            this.httpsConnectorConfig = httpsConnector;
            return (T)this;
        }

        @JsonProperty(value="maxConnectionsCount")
        public T setMaxConnectionsCount(Integer maxConnectionsCount) {
            if (maxConnectionsCount != null) {
                this.maxConnectionsCount = maxConnectionsCount;
            }
            return (T)this;
        }

        @JsonProperty(value="compressResponses")
        public T setCompressResponses(boolean compressResponses) {
            this.compressResponses = compressResponses;
            return (T)this;
        }

        public NettyServerConfig build() {
            return new NettyServerConfig(this);
        }
    }
}

