/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.hotels.styx.api.MetricRegistry;
import com.hotels.styx.server.HttpsConnectorConfig;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;

public final class SslContexts {
    private SslContexts() {
    }

    public static SslContext newSSLContext(HttpsConnectorConfig httpsConnectorConfig) {
        SslContextBuilder builder = httpsConnectorConfig.isConfigured() ? SslContexts.sslContextFromConfiguration(httpsConnectorConfig) : SslContexts.sslContextFromSelfSignedCertificate(httpsConnectorConfig);
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    public static SslContext newSSLContext(HttpsConnectorConfig httpsConnectorConfig, MetricRegistry metricRegistry) {
        SslContext sslContext = SslContexts.newSSLContext(httpsConnectorConfig);
        SslContexts.registerOpenSslStats(sslContext, metricRegistry);
        return sslContext;
    }

    private static void registerOpenSslStats(SslContext sslContext, MetricRegistry metricRegistry) {
        SSLSessionContext sslSessionContext = sslContext.sessionContext();
        if (sslSessionContext instanceof OpenSslSessionContext) {
            OpenSslSessionStats stats = ((OpenSslSessionContext)sslSessionContext).stats();
            MetricRegistry sessionStatsRegistry = metricRegistry.scope("connections.openssl.session");
            sessionStatsRegistry.register("number", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).number()));
            sessionStatsRegistry.register("accept", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).accept()));
            sessionStatsRegistry.register("acceptGood", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).acceptGood()));
            sessionStatsRegistry.register("acceptRenegotiate", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).acceptRenegotiate()));
            sessionStatsRegistry.register("hits", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).hits()));
            sessionStatsRegistry.register("misses", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).misses()));
            sessionStatsRegistry.register("cbHits", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).cbHits()));
            sessionStatsRegistry.register("cacheFull", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).cacheFull()));
            sessionStatsRegistry.register("timeouts", (Metric)((Gauge)() -> ((OpenSslSessionStats)stats).timeouts()));
        }
    }

    private static SelfSignedCertificate newSelfSignedCertificate() {
        try {
            return new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static SslContextBuilder sslContextFromSelfSignedCertificate(HttpsConnectorConfig httpsConnectorConfig) {
        SelfSignedCertificate certificate = SslContexts.newSelfSignedCertificate();
        return SslContextBuilder.forServer((File)certificate.certificate(), (File)certificate.privateKey()).protocols(SslContexts.toProtocolsOrDefault(httpsConnectorConfig.protocols())).ciphers(SslContexts.toCiphersOrDefault(httpsConnectorConfig.ciphers())).sslProvider(SslProvider.valueOf((String)httpsConnectorConfig.sslProvider()));
    }

    private static SslContextBuilder sslContextFromConfiguration(HttpsConnectorConfig httpsConnectorConfig) {
        return SslContextBuilder.forServer((File)new File(httpsConnectorConfig.certificateFile()), (File)new File(httpsConnectorConfig.certificateKeyFile())).sslProvider(SslProvider.valueOf((String)httpsConnectorConfig.sslProvider())).ciphers(SslContexts.toCiphersOrDefault(httpsConnectorConfig.ciphers())).sessionTimeout(TimeUnit.MILLISECONDS.toSeconds(httpsConnectorConfig.sessionTimeoutMillis())).sessionCacheSize(httpsConnectorConfig.sessionCacheSize()).protocols(SslContexts.toProtocolsOrDefault(httpsConnectorConfig.protocols()));
    }

    private static Iterable<String> toCiphersOrDefault(List<String> ciphers) {
        return ciphers.isEmpty() ? null : ciphers;
    }

    private static String[] toProtocolsOrDefault(List<String> elems) {
        return elems != null && elems.size() > 0 ? elems.toArray(new String[elems.size()]) : null;
    }
}

