/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty;

import com.hotels.styx.api.HttpHandler;
import com.hotels.styx.server.ConnectorConfig;
import com.hotels.styx.server.HttpsConnectorConfig;
import com.hotels.styx.server.netty.ServerConnector;
import com.hotels.styx.server.netty.ServerConnectorFactory;
import com.hotels.styx.server.netty.SslContexts;
import com.hotels.styx.server.netty.codec.NettyToStyxRequestDecoder;
import com.hotels.styx.server.netty.connectors.HttpPipelineHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Objects;

public class WebServerConnectorFactory
implements ServerConnectorFactory {
    @Override
    public ServerConnector create(ConnectorConfig config) {
        return new WebServerConnector(config);
    }

    private static final class WebServerConnector
    implements ServerConnector {
        private final ConnectorConfig config;

        private WebServerConnector(ConnectorConfig config) {
            this.config = Objects.requireNonNull(config);
        }

        @Override
        public String type() {
            return this.config.type();
        }

        @Override
        public int port() {
            return this.config.port();
        }

        @Override
        public void configure(Channel channel, HttpHandler httpHandler) {
            if (this.isHttps()) {
                channel.pipeline().addLast(new ChannelHandler[]{this.sslHandler(channel)});
            }
            channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new NettyToStyxRequestDecoder.Builder().build()}).addLast(new ChannelHandler[]{new HttpPipelineHandler.Builder(httpHandler).build()});
        }

        private SslHandler sslHandler(Channel channel) {
            SslContext sslContext = SslContexts.newSSLContext((HttpsConnectorConfig)this.config);
            return sslContext.newHandler(channel.alloc());
        }

        private boolean isHttps() {
            return "https".equals(this.config.type());
        }
    }
}

