/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.codec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.hotels.styx.api.Buffer;
import com.hotels.styx.api.ByteStream;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.Url;
import com.hotels.styx.api.exceptions.TransportException;
import com.hotels.styx.common.QueueDrainingExecutor;
import com.hotels.styx.common.content.FlowControllingHttpContentProducer;
import com.hotels.styx.common.content.FlowControllingPublisher;
import com.hotels.styx.common.format.DefaultHttpMessageFormatter;
import com.hotels.styx.common.format.HttpMessageFormatter;
import com.hotels.styx.server.BadRequestException;
import com.hotels.styx.server.UniqueIdSupplier;
import com.hotels.styx.server.UniqueIdSuppliers;
import com.hotels.styx.server.netty.codec.UnwiseCharsEncoder;
import com.hotels.styx.server.netty.codec.UrlDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

public final class NettyToStyxRequestDecoder
extends MessageToMessageDecoder<HttpObject> {
    private static final long DEFAULT_INACTIVITY_TIMEOUT_MS = 60000L;
    private final UniqueIdSupplier uniqueIdSupplier;
    private final UnwiseCharsEncoder unwiseCharEncoder;
    private HttpMessageFormatter httpMessageFormatter;
    private final long inactivityTimeoutMs;
    private Optional<FlowControllingHttpContentProducer> producer = Optional.empty();
    private final Executor queueDrainingExecutor = new QueueDrainingExecutor();

    private NettyToStyxRequestDecoder(Builder builder) {
        this.uniqueIdSupplier = builder.uniqueIdSupplier;
        this.unwiseCharEncoder = builder.unwiseCharEncoder;
        this.httpMessageFormatter = builder.httpMessageFormatter;
        this.inactivityTimeoutMs = builder.inactivityTimeoutMs;
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg.getDecoderResult().isFailure()) {
            String formattedHttpObject = this.httpMessageFormatter.formatNettyMessage(msg);
            throw new BadRequestException("Error while decoding request: " + formattedHttpObject, this.httpMessageFormatter.wrap(msg.getDecoderResult().cause()));
        }
        try {
            if (msg instanceof HttpRequest) {
                ctx.channel().config().setAutoRead(false);
                ctx.channel().read();
                HttpRequest nettyRequest = (HttpRequest)msg;
                this.producer = Optional.of(this.createProducer(ctx, nettyRequest.uri()));
                FlowControllingPublisher contentPublisher = new FlowControllingPublisher(this.queueDrainingExecutor, this.producer.get());
                LiveHttpRequest styxRequest = this.toStyxRequest(nettyRequest, (Publisher<Buffer>)contentPublisher);
                out.add(styxRequest);
            }
            if (msg instanceof HttpContent) {
                assert (this.producer.isPresent());
                ByteBuf content = ((ByteBufHolder)msg).content();
                if (content.isReadable()) {
                    ByteBuf byteBuf = (ByteBuf)ReferenceCountUtil.retain((Object)content);
                    this.queueDrainingExecutor.execute(() -> this.producer.get().newChunk(byteBuf));
                }
                if (msg instanceof LastHttpContent) {
                    this.queueDrainingExecutor.execute(() -> this.producer.get().lastHttpContent());
                }
            }
        }
        catch (BadRequestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BadRequestException(ex.getMessage() + " in " + msg, ex);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        TransportException cause = new TransportException("Connection to client lost: " + ctx.channel().remoteAddress());
        this.producer.ifPresent(it -> it.channelInactive((Throwable)cause));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof TooLongFrameException) {
            this.producer.ifPresent(it -> it.channelException((Throwable)new BadRequestException(cause.getMessage(), cause)));
        } else {
            this.producer.ifPresent(it -> it.channelException(cause));
        }
        super.exceptionCaught(ctx, cause);
    }

    private FlowControllingHttpContentProducer createProducer(ChannelHandlerContext ctx, String uri) {
        String loggingPrefix = String.format("Request body. %s [remote: %s, local: %s]", uri, ctx.channel().remoteAddress(), ctx.channel().localAddress());
        return new FlowControllingHttpContentProducer(() -> ctx.channel().read(), () -> ctx.channel().config().setAutoRead(true), cause -> {}, String.format("%s, %s", loggingPrefix, ""), this.inactivityTimeoutMs, ctx.channel().eventLoop());
    }

    private LiveHttpRequest toStyxRequest(HttpRequest request, Publisher<Buffer> contentPublisher) {
        NettyToStyxRequestDecoder.validateHostHeader(request);
        return this.makeAStyxRequestFrom(request, contentPublisher).removeHeader(HttpHeaderNames.EXPECT).build();
    }

    private static void validateHostHeader(HttpRequest request) {
        List hosts = request.headers().getAll(HttpHeaderNames.HOST);
        if (Iterables.size((Iterable)hosts) != 1 || !NettyToStyxRequestDecoder.isValidHostName((String)Iterables.getOnlyElement((Iterable)hosts))) {
            throw new BadRequestException("Bad Host header. Missing/Mismatch of Host header: " + request);
        }
    }

    private static boolean isValidHostName(String host) {
        try {
            new URL("http://" + host);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    LiveHttpRequest.Builder makeAStyxRequestFrom(HttpRequest request, Publisher<Buffer> content) {
        Url url = UrlDecoder.decodeUrl(this.unwiseCharEncoder, request);
        LiveHttpRequest.Builder requestBuilder = new LiveHttpRequest.Builder().method(this.toStyxMethod(request.method())).url(url).version(this.toStyxVersion(request.protocolVersion())).id(this.uniqueIdSupplier.get()).body(new ByteStream(content));
        StreamSupport.stream(request.headers().spliterator(), false).forEach(entry -> requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue()));
        return requestBuilder;
    }

    private com.hotels.styx.api.HttpVersion toStyxVersion(HttpVersion httpVersion) {
        return com.hotels.styx.api.HttpVersion.httpVersion((String)httpVersion.toString());
    }

    private com.hotels.styx.api.HttpMethod toStyxMethod(HttpMethod method) {
        return com.hotels.styx.api.HttpMethod.httpMethod((String)method.name());
    }

    public static final class Builder {
        private UniqueIdSupplier uniqueIdSupplier = UniqueIdSuppliers.UUID_VERSION_ONE_SUPPLIER;
        private UnwiseCharsEncoder unwiseCharEncoder = UnwiseCharsEncoder.IGNORE;
        private HttpMessageFormatter httpMessageFormatter = new DefaultHttpMessageFormatter();
        private long inactivityTimeoutMs = 60000L;

        public Builder uniqueIdSupplier(UniqueIdSupplier uniqueIdSupplier) {
            this.uniqueIdSupplier = Objects.requireNonNull(uniqueIdSupplier);
            return this;
        }

        public Builder unwiseCharEncoder(UnwiseCharsEncoder unwiseCharEncoder) {
            this.unwiseCharEncoder = Objects.requireNonNull(unwiseCharEncoder);
            return this;
        }

        public Builder httpMessageFormatter(HttpMessageFormatter httpMessageFormatter) {
            this.httpMessageFormatter = httpMessageFormatter;
            return this;
        }

        public Builder inactivityTimeoutMs(long inactivityTimeoutMs) {
            this.inactivityTimeoutMs = inactivityTimeoutMs;
            return this;
        }

        public NettyToStyxRequestDecoder build() {
            return new NettyToStyxRequestDecoder(this);
        }
    }
}

