/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.codec;

import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.Url;
import com.hotels.styx.server.netty.codec.UnwiseCharsEncoder;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;

final class UrlDecoder {
    private UrlDecoder() {
    }

    static Url decodeUrl(UnwiseCharsEncoder unwiseCharEncoder, HttpRequest request) {
        String host = request.headers().get(HttpHeaderNames.HOST);
        if (request.uri().startsWith("/") && host != null) {
            URI uri = URI.create("http://" + host + unwiseCharEncoder.encode(request.uri()));
            return new Url.Builder().path(uri.getRawPath()).rawQuery(uri.getRawQuery()).fragment(uri.getFragment()).build();
        }
        return Url.Builder.url((String)unwiseCharEncoder.encode(request.uri())).build();
    }
}

