/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.connectors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hotels.styx.api.HttpResponseStatus;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExceptionStatusMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionStatusMapper.class);
    private final Multimap<HttpResponseStatus, Class<? extends Exception>> multimap;

    private ExceptionStatusMapper(Builder builder) {
        this.multimap = ImmutableMultimap.copyOf((Multimap)builder.multimap);
    }

    Optional<HttpResponseStatus> statusFor(Throwable throwable) {
        List matchingStatuses = this.multimap.entries().stream().filter(entry -> ((Class)entry.getValue()).isInstance(throwable)).sorted(Comparator.comparing(entry -> ((HttpResponseStatus)entry.getKey()).code())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (matchingStatuses.size() > 1) {
            LOG.error("Multiple matching statuses for throwable={} statuses={}", (Object)throwable, matchingStatuses);
            return Optional.empty();
        }
        return matchingStatuses.stream().findFirst();
    }

    static final class Builder {
        private final Multimap<HttpResponseStatus, Class<? extends Exception>> multimap = HashMultimap.create();

        @SafeVarargs
        public final Builder add(HttpResponseStatus status, Class<? extends Exception> ... classes) {
            this.multimap.putAll((Object)status, Arrays.asList(classes));
            return this;
        }

        public ExceptionStatusMapper build() {
            return new ExceptionStatusMapper(this);
        }
    }
}

