/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.connectors;

import com.hotels.styx.api.LiveHttpResponse;
import com.hotels.styx.server.netty.connectors.ResponseTranslator;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

class StyxToNettyResponseTranslator
implements ResponseTranslator {
    StyxToNettyResponseTranslator() {
    }

    @Override
    public HttpResponse toNettyResponse(LiveHttpResponse httpResponse) {
        HttpVersion version = StyxToNettyResponseTranslator.toNettyVersion(httpResponse.version());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)httpResponse.status().code());
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(version, httpResponseStatus, true);
        httpResponse.headers().forEach(httpHeader -> nettyResponse.headers().add(httpHeader.name(), (Object)httpHeader.value()));
        return nettyResponse;
    }

    private static HttpVersion toNettyVersion(com.hotels.styx.api.HttpVersion version) {
        return HttpVersion.valueOf((String)version.toString());
    }
}

