/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.handlers;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ChannelStatisticsHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelStatisticsHandler.class);
    private final com.hotels.styx.api.MetricRegistry metricRegistry;
    private final Counter receivedBytesCount;
    private final Counter sentBytesCount;
    private final Counter totalConnections;

    public ChannelStatisticsHandler(com.hotels.styx.api.MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry.scope("connections");
        this.receivedBytesCount = this.metricRegistry.counter("bytes-received");
        this.sentBytesCount = this.metricRegistry.counter("bytes-sent");
        this.totalConnections = this.metricRegistry.counter("total-connections");
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.updateChannelPerThreadCounters(1);
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.updateChannelPerThreadCounters(-1);
        super.channelUnregistered(ctx);
    }

    private void updateChannelPerThreadCounters(int amount) {
        Thread thread = Thread.currentThread();
        Counter channelCount = this.metricRegistry.counter(MetricRegistry.name((String)ChannelStatisticsHandler.counterPrefix(thread), (String[])new String[]{"registered-channel-count"}));
        channelCount.inc((long)amount);
        Histogram histogram = this.metricRegistry.histogram(MetricRegistry.name((String)ChannelStatisticsHandler.counterPrefix(thread), (String[])new String[]{"channels"}));
        histogram.update(channelCount.getCount());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.totalConnections.inc();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.totalConnections.dec();
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.receivedBytesCount.inc((long)((ByteBuf)msg).readableBytes());
        } else if (msg instanceof ByteBufHolder) {
            this.receivedBytesCount.inc((long)((ByteBufHolder)msg).content().readableBytes());
        } else {
            LOGGER.warn(String.format("channelRead(): Expected byte buffers, but got [%s]", msg));
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.sentBytesCount.inc((long)((ByteBuf)msg).readableBytes());
        } else if (msg instanceof ByteBufHolder) {
            this.sentBytesCount.inc((long)((ByteBufHolder)msg).content().readableBytes());
        }
        super.write(ctx, msg, promise);
    }

    private static String counterPrefix(Thread thread) {
        return MetricRegistry.name((String)"eventloop", (String[])new String[]{thread.getName()});
    }
}

