/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.handlers;

import com.hotels.styx.common.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ExcessConnectionRejector
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcessConnectionRejector.class);
    private final ChannelGroup channelGroup;
    private final int maxConnectionsCount;

    public ExcessConnectionRejector(ChannelGroup channelGroup, int maxConnectionsCount) {
        Preconditions.checkArgument((maxConnectionsCount > 0 ? 1 : 0) != 0);
        this.channelGroup = Objects.requireNonNull(channelGroup);
        this.maxConnectionsCount = maxConnectionsCount;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.channelGroup.size() >= this.maxConnectionsCount) {
            LOGGER.warn("Max allowed connection to server exceeded: current={} configured={}", (Object)this.channelGroup.size(), (Object)this.maxConnectionsCount);
            ctx.close();
            return;
        }
        this.channelGroup.add((Object)ctx.channel());
        super.channelRegistered(ctx);
    }
}

