/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.netty.handlers;

import com.hotels.styx.server.RequestTimeoutException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

public class RequestTimeoutHandler
extends ChannelInboundHandlerAdapter {
    private boolean requestOngoing;
    private Object msg;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest && ((HttpRequest)msg).getDecoderResult().isSuccess()) {
            this.requestOngoing = true;
            this.msg = msg;
        } else if (msg instanceof LastHttpContent) {
            this.requestOngoing = false;
        }
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE && this.requestOngoing) {
            throw new RequestTimeoutException("message=" + String.valueOf(this.msg));
        }
        super.userEventTriggered(ctx, evt);
    }
}

