/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.routing;

import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.api.RequestCookie;
import com.hotels.styx.server.routing.Condition;
import com.hotels.styx.server.routing.Matcher;
import com.hotels.styx.server.routing.antlr.AntlrConditionParser;

public final class AntlrMatcher
implements Matcher {
    private static final Condition.Parser CONDITION_PARSER = new AntlrConditionParser.Builder().registerFunction("method", (request, context) -> request.method().name()).registerFunction("path", (request, context) -> request.path()).registerFunction("userAgent", (request, context) -> request.header(HttpHeaderNames.USER_AGENT).orElse("")).registerFunction("protocol", (request, context) -> context.isSecure() ? "https" : "http").registerFunction("header", (request, context, input) -> request.header((CharSequence)input).orElse("")).registerFunction("cookie", (request, context, input) -> request.cookie(input).map(RequestCookie::value).orElse("")).build();
    private final Condition condition;

    public static AntlrMatcher antlrMatcher(String conditionString) {
        Condition condition = CONDITION_PARSER.parse(conditionString);
        return new AntlrMatcher(condition);
    }

    private AntlrMatcher(Condition condition) {
        this.condition = condition;
    }

    @Override
    public boolean apply(LiveHttpRequest request, HttpInterceptor.Context context) {
        return this.condition.evaluate(request, context);
    }
}

