/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.routing.antlr;

import com.hotels.styx.server.routing.ConditionBaseVisitor;
import com.hotels.styx.server.routing.ConditionParser;
import com.hotels.styx.server.routing.antlr.Expression;
import com.hotels.styx.server.routing.antlr.Function0;
import com.hotels.styx.server.routing.antlr.Function1;
import com.hotels.styx.server.routing.antlr.FunctionResolver;
import com.hotels.styx.server.routing.antlr.StringCompareVisitor;
import com.hotels.styx.server.routing.antlr.Strings;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

class ExpressionVisitor
extends ConditionBaseVisitor<Expression<Boolean>> {
    private final StringCompareVisitor stringVisitor;

    public ExpressionVisitor(Map<String, Function0> zeroArgumentFunctions, Map<String, Function1> oneArgumentFunctions) {
        this.stringVisitor = new StringCompareVisitor(new FunctionResolver(zeroArgumentFunctions, oneArgumentFunctions));
    }

    @Override
    public Expression<Boolean> visitAndExpression(ConditionParser.AndExpressionContext ctx) {
        Expression left = (Expression)this.visit((ParseTree)ctx.expression(0));
        Expression right = (Expression)this.visit((ParseTree)ctx.expression(1));
        return (request, context) -> (Boolean)left.evaluate(request, context) != false && (Boolean)right.evaluate(request, context) != false;
    }

    @Override
    public Expression<Boolean> visitOrExpression(ConditionParser.OrExpressionContext ctx) {
        Expression left = (Expression)this.visit((ParseTree)ctx.expression(0));
        Expression right = (Expression)this.visit((ParseTree)ctx.expression(1));
        return (request, context) -> (Boolean)left.evaluate(request, context) != false || (Boolean)right.evaluate(request, context) != false;
    }

    @Override
    public Expression<Boolean> visitNotExpression(ConditionParser.NotExpressionContext ctx) {
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
        return (request, context) -> (Boolean)expression.evaluate(request, context) == false;
    }

    @Override
    public Expression<Boolean> visitSubExpression(ConditionParser.SubExpressionContext ctx) {
        Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
        return expression::evaluate;
    }

    @Override
    public Expression<Boolean> visitStringIsPresent(ConditionParser.StringIsPresentContext ctx) {
        Expression stringExpression = (Expression)this.stringVisitor.visitStringExpression(ctx.stringExpression());
        return (request, context) -> com.hotels.styx.common.Strings.isNotEmpty((String)((String)stringExpression.evaluate(request, context)));
    }

    @Override
    public Expression<Boolean> visitStringEqualsString(ConditionParser.StringEqualsStringContext ctx) {
        Expression left = (Expression)this.stringVisitor.visitStringExpression(ctx.stringExpression(0));
        Expression right = (Expression)this.stringVisitor.visitStringExpression(ctx.stringExpression(1));
        return (request, context) -> {
            String leftValue = (String)left.evaluate(request, context);
            return (leftValue == null ? "" : leftValue).equals(right.evaluate(request, context));
        };
    }

    @Override
    public Expression<Boolean> visitStringMatchesRegexp(ConditionParser.StringMatchesRegexpContext ctx) {
        Expression stringExpression = (Expression)this.stringVisitor.visitStringExpression(ctx.stringExpression());
        Pattern pattern = Pattern.compile(Strings.stripFirstAndLastCharacter(ctx.string().getText()));
        return (request, context) -> {
            String evaluate = (String)stringExpression.evaluate(request, context);
            return pattern.matcher(evaluate).matches();
        };
    }
}

