/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.routing.antlr;

import com.hotels.styx.api.HttpInterceptor;
import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.server.routing.antlr.DslFunctionResolutionError;
import com.hotels.styx.server.routing.antlr.Function0;
import com.hotels.styx.server.routing.antlr.Function1;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class FunctionResolver {
    private final Map<String, Function0> zeroArgumentFunctions;
    private final Map<String, Function1> oneArgumentFunctions;

    public FunctionResolver(Map<String, Function0> zeroArgumentFunctions, Map<String, Function1> oneArgumentFunctions) {
        this.zeroArgumentFunctions = Objects.requireNonNull(zeroArgumentFunctions);
        this.oneArgumentFunctions = Objects.requireNonNull(oneArgumentFunctions);
    }

    PartialFunction resolveFunction(String name, List<String> arguments) {
        int argumentSize = arguments.size();
        String argumentsRepresentation = String.join((CharSequence)", ", arguments);
        switch (argumentSize) {
            case 0: {
                Function0 function0 = FunctionResolver.ensureNotNull(this.zeroArgumentFunctions.get(name), "No such function=[%s], with n=[%d] arguments=[%s]", name, argumentSize, argumentsRepresentation);
                return function0::call;
            }
            case 1: {
                Function1 function1 = FunctionResolver.ensureNotNull(this.oneArgumentFunctions.get(name), "No such function=[%s], with n=[%d] arguments=[%s]", name, argumentSize, argumentsRepresentation);
                return (request, context) -> function1.call(request, context, (String)arguments.get(0));
            }
        }
        throw new IllegalArgumentException(String.format("No such function=[%s], with n=[%d] arguments=[%s]", name, argumentSize, argumentsRepresentation));
    }

    private static <T> T ensureNotNull(T functionRef, String message, String name, int argumentSize, String argumentsRepresentation) {
        if (functionRef == null) {
            throw new DslFunctionResolutionError(String.format(message, name, argumentSize, argumentsRepresentation));
        }
        return functionRef;
    }

    static interface PartialFunction {
        public String call(LiveHttpRequest var1, HttpInterceptor.Context var2);
    }
}

