/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.routing.antlr;

import com.hotels.styx.server.routing.ConditionBaseVisitor;
import com.hotels.styx.server.routing.ConditionParser;
import com.hotels.styx.server.routing.antlr.Expression;
import com.hotels.styx.server.routing.antlr.FunctionResolver;
import com.hotels.styx.server.routing.antlr.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;

class StringCompareVisitor
extends ConditionBaseVisitor<Expression<String>> {
    private final FunctionResolver functionResolver;

    public StringCompareVisitor(FunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Override
    public Expression<String> visitString(ConditionParser.StringContext ctx) {
        return (request, context) -> Strings.stripFirstAndLastCharacter(ctx.getText());
    }

    @Override
    public Expression<String> visitFunction(ConditionParser.FunctionContext ctx) {
        String name = ctx.ID().getSymbol().getText();
        List<String> arguments = this.extractArguments(ctx.arglist());
        FunctionResolver.PartialFunction function = this.functionResolver.resolveFunction(name, arguments);
        return function::call;
    }

    private List<String> extractArguments(ConditionParser.ArglistContext arglist) {
        return arglist.string().stream().map(RuleContext::getText).map(Strings::stripFirstAndLastCharacter).collect(Collectors.toList());
    }
}

