/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.server.track;

import com.hotels.styx.api.LiveHttpRequest;
import com.hotels.styx.server.track.CurrentRequest;
import com.hotels.styx.server.track.RequestTracker;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class CurrentRequestTracker
implements RequestTracker {
    public static final CurrentRequestTracker INSTANCE = new CurrentRequestTracker();
    private final ConcurrentHashMap<Object, CurrentRequest> currentRequests = new ConcurrentHashMap();

    @Override
    public void trackRequest(LiveHttpRequest request, Supplier<String> state) {
        if (this.currentRequests.containsKey(request.id())) {
            this.currentRequests.get(request.id()).setCurrentThread(Thread.currentThread());
        } else {
            this.currentRequests.put(request.id(), new CurrentRequest(request, state));
        }
    }

    @Override
    public void trackRequest(LiveHttpRequest request) {
        if (this.currentRequests.containsKey(request.id())) {
            this.currentRequests.get(request.id()).setCurrentThread(Thread.currentThread());
        } else {
            this.trackRequest(request, () -> "Status NOT Available.");
        }
    }

    @Override
    public void markRequestAsSent(LiveHttpRequest request) {
        if (this.currentRequests.containsKey(request.id())) {
            this.currentRequests.get(request.id()).requestSent();
        }
    }

    @Override
    public void endTrack(LiveHttpRequest request) {
        this.currentRequests.remove(request.id());
    }

    public Collection<CurrentRequest> currentRequests() {
        return this.currentRequests.values();
    }
}

