/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl.pwg;

import com.hp.jipp.pdl.RenderableDocument;
import com.hp.jipp.pdl.RenderablePage;
import com.hp.jipp.pdl.pwg.PwgHeader;
import com.hp.jipp.pdl.pwg.PwgSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\tH\u0002R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgWriter;", "Ljava/io/DataOutputStream;", "outputStream", "Ljava/io/OutputStream;", "settings", "Lcom/hp/jipp/pdl/pwg/PwgSettings;", "headerCustomizer", "Lkotlin/Function2;", "Lcom/hp/jipp/pdl/RenderablePage;", "Lcom/hp/jipp/pdl/pwg/PwgHeader;", "(Ljava/io/OutputStream;Lcom/hp/jipp/pdl/pwg/PwgSettings;Lkotlin/jvm/functions/Function2;)V", "getHeaderCustomizer", "()Lkotlin/jvm/functions/Function2;", "write", "", "doc", "Lcom/hp/jipp/pdl/RenderableDocument;", "writePageContent", "page", "header", "Companion", "jipp-pdl"})
public final class PwgWriter
extends DataOutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PwgSettings settings;
    @NotNull
    private final Function2<RenderablePage, PwgHeader, PwgHeader> headerCustomizer;
    @NotNull
    private static final byte[] MAGIC_NUMBER;
    public static final int MAX_SWATH_HEIGHT = 64;

    @JvmOverloads
    public PwgWriter(@NotNull OutputStream outputStream, @NotNull PwgSettings settings, @NotNull Function2<? super RenderablePage, ? super PwgHeader, PwgHeader> headerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(headerCustomizer, (String)"headerCustomizer");
        super(outputStream);
        this.settings = settings;
        this.headerCustomizer = headerCustomizer;
    }

    public /* synthetic */ PwgWriter(OutputStream outputStream, PwgSettings pwgSettings, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pwgSettings = new PwgSettings(null, null, null, false, 15, null);
        }
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(outputStream, pwgSettings, (Function2<? super RenderablePage, ? super PwgHeader, PwgHeader>)function2);
    }

    @NotNull
    public final Function2<RenderablePage, PwgHeader, PwgHeader> getHeaderCustomizer() {
        return this.headerCustomizer;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull RenderableDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.write(MAGIC_NUMBER);
        Iterable $this$forEachIndexed$iv = doc.mapPages((Function1<? super RenderableDocument, ? extends Iterable<? extends RenderablePage>>)((Function1)new Function1<RenderableDocument, Iterable<? extends RenderablePage>>(this, doc){
            final /* synthetic */ PwgWriter this$0;
            final /* synthetic */ RenderableDocument $doc;
            {
                this.this$0 = $receiver;
                this.$doc = $doc;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<RenderablePage> invoke(@NotNull RenderableDocument it) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable iterable = it;
                PwgWriter pwgWriter = this.this$0;
                RenderableDocument renderableDocument = this.$doc;
                boolean $i$f$mapIndexed = false;
                void var6_6 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void num;
                    void page;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    RenderablePage renderablePage = (RenderablePage)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    PwgHeader header = PwgWriter.access$getSettings$p(pwgWriter).buildHeader(renderableDocument, (RenderablePage)page, (int)num);
                    Pair pair = TuplesKt.to((Object)header.getFeedTransform(), (Object)header.getCrossFeedTransform());
                    RenderablePage renderablePage2 = Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)-1, (Object)-1)) ? page.rotated() : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)1, (Object)-1)) ? page.flipX() : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)-1, (Object)1)) ? page.flipY() : page));
                    collection.add(renderablePage2);
                }
                return (List)destination$iv$iv;
            }
        })).handleSides(this.settings.getOutput(), this.settings.getAllowPadding());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void page;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RenderablePage renderablePage = (RenderablePage)item$iv;
            int num = n;
            boolean bl2 = false;
            PwgHeader header = (PwgHeader)this.getHeaderCustomizer().invoke((Object)page, (Object)this.settings.buildHeader(doc, (RenderablePage)page, num));
            header.write(this);
            this.writePageContent((RenderablePage)page, header);
        }
    }

    private final void writePageContent(RenderablePage page, PwgHeader header) {
        int height;
        int size = 0;
        byte[] byteArray = null;
        for (int yOffset = 0; yOffset < page.getHeightPixels(); yOffset += height) {
            int n = 64;
            int n2 = page.getHeightPixels() - yOffset;
            boolean bl = false;
            height = Math.min(n, n2);
            int renderSize = page.renderSize(height, this.settings.getOutput().getColorSpace());
            byte[] byArray = byteArray;
            if (!(byArray == null ? false : byArray.length == renderSize)) {
                byteArray = new byte[renderSize];
            }
            page.render(yOffset, height, this.settings.getOutput().getColorSpace(), byteArray);
            ByteArrayOutputStream encodedBytes = new ByteArrayOutputStream();
            header.getPackBits().encode(new ByteArrayInputStream(byteArray), encodedBytes);
            this.write(encodedBytes.toByteArray());
            size += encodedBytes.size();
        }
    }

    @JvmOverloads
    public PwgWriter(@NotNull OutputStream outputStream, @NotNull PwgSettings settings) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(outputStream, settings, null, 4, null);
    }

    @JvmOverloads
    public PwgWriter(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this(outputStream, null, null, 6, null);
    }

    public static final /* synthetic */ PwgSettings access$getSettings$p(PwgWriter $this) {
        return $this.settings;
    }

    static {
        String string = "RaS2";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        MAGIC_NUMBER = byArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgWriter$Companion;", "", "()V", "MAGIC_NUMBER", "", "getMAGIC_NUMBER", "()[B", "MAX_SWATH_HEIGHT", "", "jipp-pdl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getMAGIC_NUMBER() {
            return MAGIC_NUMBER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

