/*
 * Decompiled with CFR 0.152.
 */
package com.hrakaroo.glob;

import com.hrakaroo.glob.MatchingEngine;

class ContainsEngine
implements MatchingEngine {
    static final int NO_SAVE_POINT = -1;
    final char[] lowerCase;
    final char[] upperCase;
    final boolean[] matchOne;
    final int length;

    protected ContainsEngine(char[] lowerCase, char[] upperCase, boolean[] matchOne, int length) {
        this.lowerCase = lowerCase;
        this.upperCase = upperCase;
        this.matchOne = matchOne;
        this.length = length;
    }

    @Override
    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < this.length - 2) {
            return false;
        }
        int charsIndex = 0;
        int patternIndex = 1;
        int charsSavePoint = -1;
        while (true) {
            if (patternIndex == this.length - 1) {
                return true;
            }
            if (charsIndex != string.length() && (this.matchOne[patternIndex] || string.charAt(charsIndex) == this.lowerCase[patternIndex] || string.charAt(charsIndex) == this.upperCase[patternIndex])) {
                if (charsSavePoint == -1) {
                    charsSavePoint = charsIndex + 1;
                }
                ++patternIndex;
                ++charsIndex;
                continue;
            }
            if (charsIndex != string.length() && charsSavePoint == -1) {
                ++charsIndex;
                continue;
            }
            if (charsSavePoint == -1) break;
            charsIndex = charsSavePoint;
            patternIndex = 1;
            charsSavePoint = -1;
        }
        return false;
    }

    @Override
    public int matchingSizeInBytes() {
        return 12 + this.staticSizeInBytes();
    }

    @Override
    public int staticSizeInBytes() {
        return this.lowerCase.length * 5 + 4;
    }
}

