/*
 * Decompiled with CFR 0.152.
 */
package com.hrakaroo.glob;

import com.hrakaroo.glob.MatchingEngine;
import java.util.Arrays;

class GlobEngine
implements MatchingEngine {
    static final int STARTING_STACK_SIZE = 16;
    final char[] lowerCase;
    final char[] upperCase;
    final boolean[] matchOne;
    final boolean[] wildcard;
    final int length;

    protected GlobEngine(char[] lowerCase, char[] upperCase, boolean[] wildcard, boolean[] matchOne, int length) {
        this.lowerCase = lowerCase;
        this.upperCase = upperCase;
        this.matchOne = matchOne;
        this.length = length;
        this.wildcard = wildcard;
    }

    @Override
    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        int[] stack = new int[16];
        int stackIndex = 0;
        int charsIndex = 0;
        int patternIndex = 0;
        while (true) {
            if (patternIndex != this.length && this.wildcard[patternIndex]) {
                if (charsIndex != string.length()) {
                    if (stackIndex == stack.length) {
                        int[] tmp = new int[stack.length * 2];
                        System.arraycopy(stack, 0, tmp, 0, stackIndex);
                        stack = tmp;
                    }
                    stack[stackIndex++] = patternIndex;
                    stack[stackIndex++] = charsIndex + 1;
                }
                ++patternIndex;
            }
            if (patternIndex == this.length && charsIndex == string.length()) {
                return true;
            }
            if (charsIndex == string.length() || patternIndex == this.length || !this.matchOne[patternIndex] && string.charAt(charsIndex) != this.lowerCase[patternIndex] && string.charAt(charsIndex) != this.upperCase[patternIndex]) {
                if (stackIndex != 0) {
                    charsIndex = stack[--stackIndex];
                    patternIndex = stack[--stackIndex];
                    continue;
                }
                return false;
            }
            ++patternIndex;
            ++charsIndex;
        }
    }

    public String toString() {
        return "GlobEngine{\nlowerCase = '" + new String(this.lowerCase) + "',\nupperCase = '" + new String(this.upperCase) + "',\nmatchOne     = " + Arrays.toString(this.matchOne) + ",\nwildcard      = " + Arrays.toString(this.wildcard) + ",\nlength    = " + this.length + "\n}";
    }

    @Override
    public int matchingSizeInBytes() {
        return 76 + this.staticSizeInBytes();
    }

    @Override
    public int staticSizeInBytes() {
        return this.lowerCase.length * 6 + 4;
    }
}

