/*
 * Decompiled with CFR 0.152.
 */
package com.hrakaroo.glob;

import com.hrakaroo.glob.ContainsEngine;
import com.hrakaroo.glob.EmptyOnlyEngine;
import com.hrakaroo.glob.EndsWithEngine;
import com.hrakaroo.glob.EqualToEngine;
import com.hrakaroo.glob.EverythingEngine;
import com.hrakaroo.glob.GlobEngine;
import com.hrakaroo.glob.MatchingEngine;
import com.hrakaroo.glob.StartsWithEngine;

public class GlobPattern {
    public static final char NULL_CHARACTER = '\u0000';
    public static final int CASE_INSENSITIVE = 1;
    public static final int HANDLE_ESCAPES = 2;

    GlobPattern() {
    }

    public static MatchingEngine compile(String globPattern) {
        return GlobPattern.compile(globPattern, '*', '?', 2);
    }

    public static MatchingEngine compile(String globPattern, char wildcardChar, char matchOneChar, int flags) {
        char[] upperCaseRaw;
        char[] lowerCaseRaw;
        boolean caseInsensitive = GlobPattern.has(flags, 1);
        boolean handleEscapes = GlobPattern.has(flags, 2);
        if (globPattern == null) {
            throw new IllegalArgumentException("Glob Pattern can not be null");
        }
        int lengthRaw = globPattern.length();
        if (caseInsensitive) {
            lowerCaseRaw = globPattern.toLowerCase().toCharArray();
            upperCaseRaw = globPattern.toUpperCase().toCharArray();
        } else {
            lowerCaseRaw = upperCaseRaw = globPattern.toCharArray();
        }
        char[] lowerCase = new char[lengthRaw];
        char[] upperCase = new char[lengthRaw];
        boolean[] wildcard = new boolean[lengthRaw];
        boolean[] matchOne = new boolean[lengthRaw];
        for (int i = 0; i < lengthRaw; ++i) {
            wildcard[i] = false;
            matchOne[i] = false;
        }
        boolean inEscape = false;
        int wildcardCount = 0;
        int index = 0;
        for (int i = 0; i < lengthRaw; ++i) {
            char lowerC = lowerCaseRaw[i];
            char upperC = upperCaseRaw[i];
            if (handleEscapes && lowerC == '\\' && !inEscape) {
                inEscape = true;
                continue;
            }
            if (wildcardChar != '\u0000' && lowerC == wildcardChar) {
                if (!inEscape) {
                    if (index != 0 && wildcard[index - 1]) continue;
                    wildcard[index] = true;
                    ++wildcardCount;
                }
            } else if (matchOneChar != '\u0000' && lowerC == matchOneChar) {
                if (!inEscape) {
                    matchOne[index] = true;
                }
            } else if (inEscape) {
                switch (lowerC) {
                    case 'r': {
                        upperC = '\r';
                        lowerC = '\r';
                        break;
                    }
                    case 'n': {
                        upperC = '\n';
                        lowerC = '\n';
                        break;
                    }
                    case 't': {
                        upperC = '\t';
                        lowerC = '\t';
                        break;
                    }
                    case '\\': {
                        upperC = '\\';
                        lowerC = '\\';
                        break;
                    }
                    case 'u': {
                        if (i + 4 < lengthRaw) {
                            String s = new String(lowerCaseRaw, i + 1, 4);
                            try {
                                char u = (char)Integer.parseInt(s, 16);
                                upperC = Character.toUpperCase(u);
                                lowerC = Character.toLowerCase(u);
                            }
                            catch (NumberFormatException e) {
                                throw new RuntimeException("Bad Unicode character: " + s);
                            }
                            i += 4;
                            break;
                        }
                        throw new RuntimeException("Bad Unicode char at end of input");
                    }
                    default: {
                        throw new RuntimeException("Unknown escape sequence : \\" + lowerC);
                    }
                }
            }
            lowerCase[index] = lowerC;
            upperCase[index] = upperC;
            ++index;
            inEscape = false;
        }
        int length = index;
        if (length == 0) {
            return EmptyOnlyEngine.EMPTY_ONLY_ENGINE;
        }
        if (length == 1 && wildcard[0]) {
            return EverythingEngine.EVERYTHING_ENGINE;
        }
        if (wildcardCount == 0) {
            return new EqualToEngine(lowerCase, upperCase, matchOne, length);
        }
        if (wildcardCount == 1) {
            if (wildcard[0]) {
                return new EndsWithEngine(lowerCase, upperCase, matchOne, length);
            }
            if (wildcard[length - 1]) {
                return new StartsWithEngine(lowerCase, upperCase, matchOne, length);
            }
        }
        if (wildcardCount == 2 && wildcard[0] && wildcard[length - 1]) {
            return new ContainsEngine(lowerCase, upperCase, matchOne, length);
        }
        return new GlobEngine(lowerCase, upperCase, wildcard, matchOne, length);
    }

    private static boolean has(int flags, int feature) {
        return (flags & feature) != 0;
    }
}

