/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.ConnectorConnection;
import com.hsbc.cranker.mucranker.ConnectorInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConnectorInstanceImpl
implements ConnectorInstance {
    private final String ip;
    private final String connectorInstanceID;
    private final ArrayList<ConnectorConnection> connections;
    private final boolean darkMode;

    ConnectorInstanceImpl(String ip, String connectorInstanceID, ArrayList<ConnectorConnection> connections, boolean darkMode) {
        this.ip = ip;
        this.connectorInstanceID = connectorInstanceID;
        this.connections = connections;
        this.darkMode = darkMode;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public String connectorInstanceID() {
        return this.connectorInstanceID;
    }

    @Override
    public List<ConnectorConnection> connections() {
        return this.connections;
    }

    @Override
    public boolean darkMode() {
        return this.darkMode;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("connectorInstanceID", this.connectorInstanceID);
        m.put("ip", this.ip);
        ArrayList<HashMap<String, Object>> cons = new ArrayList<HashMap<String, Object>>();
        for (ConnectorConnection con : this.connections) {
            cons.add(con.toMap());
        }
        m.put("connections", cons);
        m.put("connectionCount", cons.size());
        m.put("darkMode", this.darkMode);
        return m;
    }

    public String toString() {
        return "ConnectorInstanceImpl{ip='" + this.ip + "', connectorInstanceID='" + this.connectorInstanceID + "', connections=" + this.connections + "}";
    }
}

