/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.ConnectorInstance;
import com.hsbc.cranker.mucranker.ConnectorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConnectorServiceImpl
implements ConnectorService {
    private final String route;
    private final String componentName;
    private final List<ConnectorInstance> instances;

    ConnectorServiceImpl(String route, String componentName, List<ConnectorInstance> instances) {
        this.route = route;
        this.componentName = componentName;
        this.instances = instances;
    }

    @Override
    public String route() {
        return this.route;
    }

    @Override
    public String componentName() {
        return this.componentName;
    }

    @Override
    public List<ConnectorInstance> connectors() {
        return this.instances;
    }

    @Override
    public boolean isCatchAll() {
        return "*".equals(this.route);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", this.route);
        m.put("componentName", this.componentName);
        m.put("isCatchAll", this.isCatchAll());
        ArrayList<Map<String, Object>> cons = new ArrayList<Map<String, Object>>();
        for (ConnectorInstance instance : this.instances) {
            cons.add(instance.toMap());
        }
        m.put("connectors", cons);
        return m;
    }

    public String toString() {
        return "ConnectorServiceImpl{route='" + this.route + "'componentName='" + this.componentName + "', instances=" + this.instances + "}";
    }
}

