/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.CrankerProtocolRequestBuilder;
import com.hsbc.cranker.mucranker.HeadersBuilder;
import com.hsbc.cranker.mucranker.ProxyInfo;
import com.hsbc.cranker.mucranker.ProxyListener;
import com.hsbc.cranker.mucranker.RouterSocket;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import com.hsbc.cranker.mucranker.WebSocketFarmV3;
import com.hsbc.cranker.mucranker.WebSocketFarmV3Holder;
import io.muserver.AsyncHandle;
import io.muserver.ContentTypes;
import io.muserver.DoneCallback;
import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.RequestBodyListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CrankerMuHandler
implements MuHandler {
    private static final Logger log;
    private static final String ANY_DOMAIN = "*";
    static final Set<String> HOP_BY_HOP;
    static final Set<String> REPRESSED;
    static final String MU_ID = "muid";
    private static final String ipAddress;
    private final Random random = new Random();
    private final WebSocketFarm webSocketFarm;
    private final WebSocketFarmV3Holder webSocketFarmV3Holder;
    private final boolean discardClientForwardedHeaders;
    private final boolean sendLegacyForwardedHeaders;
    private final String viaValue;
    private final Set<String> doNotProxy;
    private final List<ProxyListener> proxyListeners;

    CrankerMuHandler(WebSocketFarm webSocketFarm, WebSocketFarmV3Holder webSocketFarmV3Holder, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue, Set<String> doNotProxy, List<ProxyListener> proxyListeners) {
        this.webSocketFarm = webSocketFarm;
        this.webSocketFarmV3Holder = webSocketFarmV3Holder;
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        this.viaValue = viaValue;
        this.doNotProxy = doNotProxy;
        this.proxyListeners = proxyListeners;
    }

    public boolean handle(MuRequest clientRequest, MuResponse clientResponse) throws Exception {
        if (clientRequest.attribute(MU_ID) == null) {
            clientRequest.attribute(MU_ID, (Object)UUID.randomUUID().toString());
        }
        if (clientRequest.method() == Method.TRACE) {
            clientResponse.status(405);
            clientResponse.write("Method not supported");
            return true;
        }
        String target = clientRequest.uri().getPath();
        String domain = clientRequest.uri().getHost();
        AsyncHandle asyncHandle = clientRequest.handleAsync();
        if (this.webSocketFarmV3Holder.canHandle(domain, target, true)) {
            return this.dispatchV3(clientRequest, clientResponse, domain, target, true, asyncHandle);
        }
        if (this.distributeTraffic(clientRequest, clientResponse, domain, target, false, asyncHandle)) {
            return true;
        }
        if (this.distributeTraffic(clientRequest, clientResponse, domain, target, true, asyncHandle)) {
            return true;
        }
        this.dispatchV1(clientRequest, clientResponse, target, true, asyncHandle);
        return true;
    }

    private boolean distributeTraffic(MuRequest clientRequest, MuResponse clientResponse, String domain, String target, boolean useCatchall, AsyncHandle asyncHandle) {
        boolean canHandleByV3 = this.webSocketFarmV3Holder.canHandle(ANY_DOMAIN, target, useCatchall);
        boolean canHandleByV1 = this.webSocketFarm.canHandle(target, useCatchall);
        if (canHandleByV3 && canHandleByV1) {
            if (this.random.nextBoolean()) {
                return this.dispatchV3(clientRequest, clientResponse, ANY_DOMAIN, target, useCatchall, asyncHandle);
            }
            return this.dispatchV1(clientRequest, clientResponse, target, useCatchall, asyncHandle);
        }
        if (canHandleByV3) {
            return this.dispatchV3(clientRequest, clientResponse, ANY_DOMAIN, target, useCatchall, asyncHandle);
        }
        if (canHandleByV1) {
            return this.dispatchV1(clientRequest, clientResponse, target, useCatchall, asyncHandle);
        }
        return false;
    }

    private boolean dispatchV1(MuRequest clientRequest, MuResponse clientResponse, String target, boolean useCatchAll, AsyncHandle asyncHandle) {
        this.webSocketFarm.acquireSocket(target, useCatchAll, clientRequest, clientResponse, (crankedSocket, waitTimeInMillis) -> this.sendRequestOverWebSocket(clientRequest, clientResponse, asyncHandle, (RouterSocket)crankedSocket, waitTimeInMillis), (statusCode, waitTimeInMillis, header, body) -> {
            CrankerMuHandler.sendSimpleResponse(clientResponse, asyncHandle, statusCode, header, body);
            if (!this.proxyListeners.isEmpty()) {
                ErrorProxyInfo proxyInfo = new ErrorProxyInfo(target, clientRequest, clientResponse, waitTimeInMillis);
                for (ProxyListener proxyListener : this.proxyListeners) {
                    proxyListener.onFailureToAcquireProxySocket(proxyInfo);
                }
            }
        });
        return true;
    }

    private boolean dispatchV3(MuRequest clientRequest, MuResponse clientResponse, String domain, String target, boolean useCatchAll, AsyncHandle asyncHandle) {
        WebSocketFarmV3 webSocketFarmV3 = this.webSocketFarmV3Holder.getWebSocketFarmV3(domain);
        if (webSocketFarmV3 == null) {
            CrankerMuHandler.sendSimpleResponse(clientResponse, asyncHandle, 503, "503 Service Unavailable", "V3 connector not available for domain");
            return true;
        }
        webSocketFarmV3.getWebSocket(target, useCatchAll).whenComplete((routerSocketV3, throwable) -> {
            if (routerSocketV3 == null || throwable != null) {
                CrankerMuHandler.sendSimpleResponse(clientResponse, asyncHandle, 503, "503 Service Unavailable", "V3 connector not available");
                if (!this.proxyListeners.isEmpty()) {
                    ErrorProxyInfo proxyInfo = new ErrorProxyInfo(target, clientRequest, clientResponse, 0L);
                    for (ProxyListener proxyListener : this.proxyListeners) {
                        proxyListener.onFailureToAcquireProxySocket(proxyInfo);
                    }
                }
                return;
            }
            routerSocketV3.sendRequestOverWebSocketV3(clientRequest, clientResponse);
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestOverWebSocket(MuRequest clientRequest, MuResponse clientResponse, final AsyncHandle asyncHandle, final RouterSocket crankedSocket, long waitTimeInMillis) {
        crankedSocket.setAsyncHandle(asyncHandle, clientRequest, clientResponse, waitTimeInMillis);
        try {
            CrankerProtocolRequestBuilder protocolRequest = CrankerProtocolRequestBuilder.newBuilder();
            protocolRequest.withRequestLine(CrankerMuHandler.createRequestLine(clientRequest));
            HeadersBuilder headers = new HeadersBuilder();
            CrankerMuHandler.setTargetRequestHeaders(clientRequest, headers, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.viaValue, this.doNotProxy);
            try {
                if (!this.proxyListeners.isEmpty()) {
                    for (ProxyListener proxyListener : this.proxyListeners) {
                        proxyListener.onBeforeProxyToTarget(crankedSocket, headers.muHeaders());
                    }
                }
            }
            catch (WebApplicationException e) {
                CrankerMuHandler.handleWebApplicationException(e, clientResponse, asyncHandle);
                crankedSocket.socketSessionClose();
                return;
            }
            protocolRequest.withRequestHeaders(headers);
            if (clientRequest.headers().hasBody()) {
                crankedSocket.sendText(protocolRequest.withRequestBodyPending().build());
                if (!this.proxyListeners.isEmpty()) {
                    for (ProxyListener proxyListener : this.proxyListeners) {
                        proxyListener.onAfterProxyToTargetHeadersSent(crankedSocket, headers.muHeaders());
                    }
                }
                asyncHandle.setReadListener(new RequestBodyListener(){

                    public void onDataReceived(ByteBuffer buffer, DoneCallback callback) {
                        try {
                            int position = buffer.position();
                            DoneCallback doneWrapper = error -> {
                                if (error == null && !CrankerMuHandler.this.proxyListeners.isEmpty()) {
                                    for (ProxyListener proxyListener : CrankerMuHandler.this.proxyListeners) {
                                        proxyListener.onRequestBodyChunkSentToTarget(crankedSocket, buffer.position(position));
                                    }
                                }
                                callback.onComplete(error);
                            };
                            crankedSocket.sendData(buffer, doneWrapper);
                        }
                        catch (Exception e) {
                            this.onError(e);
                        }
                    }

                    public void onComplete() {
                        try {
                            String bodyEndedRequestMsg = CrankerProtocolRequestBuilder.newBuilder().withRequestBodyEnded().build();
                            crankedSocket.sendText(bodyEndedRequestMsg);
                            if (!CrankerMuHandler.this.proxyListeners.isEmpty()) {
                                for (ProxyListener proxyListener : CrankerMuHandler.this.proxyListeners) {
                                    proxyListener.onRequestBodySentToTarget(crankedSocket);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.onError(e);
                        }
                    }

                    public void onError(Throwable t) {
                        asyncHandle.complete(t);
                        try {
                            crankedSocket.onError(t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                crankedSocket.sendText(protocolRequest.withRequestHasNoBody().build());
                if (!this.proxyListeners.isEmpty()) {
                    for (ProxyListener proxyListener : this.proxyListeners) {
                        proxyListener.onAfterProxyToTargetHeadersSent(crankedSocket, headers.muHeaders());
                        proxyListener.onRequestBodySentToTarget(crankedSocket);
                    }
                }
            }
        }
        catch (WebApplicationException e) {
            CrankerMuHandler.handleWebApplicationException(e, clientResponse, asyncHandle);
            crankedSocket.socketSessionClose();
            return;
        }
        catch (Throwable e) {
            CrankerMuHandler.handleException(clientRequest, clientResponse, asyncHandle, e);
            try {
                crankedSocket.socketSessionClose();
            }
            catch (Throwable ei) {
                log.error("Fail to close crankedSocket, routerName=" + crankedSocket.route + ", routerSocketID=" + crankedSocket.routerSocketID + " \n" + ei.getMessage());
            }
            finally {
                asyncHandle.complete();
            }
        }
    }

    static void handleException(MuRequest clientRequest, MuResponse clientResponse, AsyncHandle asyncHandle, Throwable e) {
        Object muId = clientRequest.attribute(MU_ID);
        log.error(String.format("Error setting up. ErrorID=%s, request.uri=%s, request.startTime=%s, response.hasStartedSendingData=%s, response.status=%s, response.state=%s", muId, clientRequest.uri(), clientRequest.startTime(), clientResponse.hasStartedSendingData(), clientResponse.status(), clientResponse.responseState()), e);
        try {
            if (!clientResponse.hasStartedSendingData()) {
                clientResponse.status(500);
                asyncHandle.write(Mutils.toByteBuffer((String)("Server ErrorID=" + muId)));
            }
        }
        catch (Throwable e1) {
            log.info("Fail to send error msg.", e1);
        }
    }

    static void handleWebApplicationException(WebApplicationException e, MuResponse response, AsyncHandle asyncHandle) {
        Response.StatusType status = e.getResponse().getStatusInfo();
        response.status(status.getStatusCode());
        String entity = Mutils.htmlEncode((String)e.getMessage());
        String header = status.getStatusCode() + " " + status.getReasonPhrase();
        CrankerMuHandler.sendSimpleResponse(response, asyncHandle, status.getStatusCode(), header, entity);
    }

    static void sendSimpleResponse(MuResponse response, AsyncHandle asyncHandle, int code, String header, String htmlBody) {
        if (response.hasStartedSendingData()) {
            asyncHandle.complete((Throwable)new RuntimeException("Was going to send " + code + " but response was already started or closed"));
        } else {
            response.status(code);
            response.headers().remove("content-length");
            response.contentType(ContentTypes.TEXT_HTML_UTF8);
            String html = "<html><head><title>" + Mutils.htmlEncode((String)header) + "</title><body><h1>" + Mutils.htmlEncode((String)header) + "</h1><p>" + htmlBody + "</p></body></html>";
            asyncHandle.write(Mutils.toByteBuffer((String)html), throwable -> {
                if (throwable == null) {
                    asyncHandle.complete();
                } else {
                    asyncHandle.complete(throwable);
                }
            });
        }
    }

    static String createRequestLine(MuRequest request) {
        String uri = request.uri().getRawPath();
        Object qs = request.uri().getRawQuery();
        qs = qs == null ? "" : "?" + (String)qs;
        return request.method().name() + " " + uri + (String)qs + " HTTP/1.1";
    }

    static boolean setTargetRequestHeaders(MuRequest clientRequest, HeadersBuilder headersBuilder, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue, Set<String> excludedHeaders) {
        Headers reqHeaders = clientRequest.headers();
        List<String> customHopByHop = CrankerMuHandler.getCustomHopByHopHeaders(reqHeaders.get(HeaderNames.CONNECTION));
        boolean hasContentLengthOrTransferEncoding = false;
        for (Map.Entry clientHeader : reqHeaders) {
            String key = (String)clientHeader.getKey();
            String lowKey = key.toLowerCase();
            if (excludedHeaders.contains(lowKey) || customHopByHop.contains(lowKey)) continue;
            hasContentLengthOrTransferEncoding |= lowKey.equals("content-length") || lowKey.equals("transfer-encoding");
            headersBuilder.appendHeader(key, (String)clientHeader.getValue());
        }
        String newViaValue = CrankerMuHandler.getNewViaValue(clientRequest.connection().protocol() + " " + viaValue, clientRequest.headers().getAll(HeaderNames.VIA));
        headersBuilder.appendHeader("via", newViaValue);
        CrankerMuHandler.setForwardedHeaders(clientRequest, headersBuilder, discardClientForwardedHeaders, sendLegacyForwardedHeaders);
        return hasContentLengthOrTransferEncoding;
    }

    private static String getNewViaValue(String viaValue, List<String> previousViasList) {
        Object previousVias = String.join((CharSequence)", ", previousViasList);
        if (!((String)previousVias).isEmpty()) {
            previousVias = (String)previousVias + ", ";
        }
        return (String)previousVias + viaValue;
    }

    public static void setForwardedHeaders(MuRequest clientRequest, HeadersBuilder headersBuilder, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders) {
        List forwardHeaders;
        Mutils.notNull((String)"clientRequest", (Object)clientRequest);
        Mutils.notNull((String)"targetRequest", (Object)headersBuilder);
        if (discardClientForwardedHeaders) {
            forwardHeaders = Collections.emptyList();
        } else {
            forwardHeaders = clientRequest.headers().forwarded();
            for (ForwardedHeader existing : forwardHeaders) {
                headersBuilder.appendHeader("forwarded", existing.toString());
            }
        }
        ForwardedHeader newForwarded = CrankerMuHandler.createForwardedHeader(clientRequest);
        headersBuilder.appendHeader("forwarded", newForwarded.toString());
        if (sendLegacyForwardedHeaders) {
            ForwardedHeader first = forwardHeaders.isEmpty() ? newForwarded : (ForwardedHeader)forwardHeaders.get(0);
            CrankerMuHandler.setXForwardedHeaders(headersBuilder, first);
        }
    }

    private static void setXForwardedHeaders(HeadersBuilder headersBuilder, ForwardedHeader forwardedHeader) {
        String forValue;
        String host;
        String proto = forwardedHeader.proto();
        if (proto != null) {
            headersBuilder.appendHeader(HeaderNames.X_FORWARDED_PROTO.toString(), proto);
        }
        if ((host = forwardedHeader.host()) != null) {
            headersBuilder.appendHeader(HeaderNames.X_FORWARDED_HOST.toString(), host);
        }
        if ((forValue = forwardedHeader.forValue()) != null) {
            headersBuilder.appendHeader(HeaderNames.X_FORWARDED_FOR.toString(), forValue);
        }
    }

    private static ForwardedHeader createForwardedHeader(MuRequest clientRequest) {
        String forwardedFor = clientRequest.remoteAddress();
        String proto = clientRequest.serverURI().getScheme();
        String host = clientRequest.headers().get(HeaderNames.HOST);
        return new ForwardedHeader(ipAddress, forwardedFor, host, proto, null);
    }

    static List<String> getCustomHopByHopHeaders(String connectionHeaderValue) {
        String[] split;
        if (connectionHeaderValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> customHopByHop = new ArrayList<String>();
        for (String s : split = connectionHeaderValue.split("\\s*,\\s*")) {
            customHopByHop.add(s.toLowerCase());
        }
        return customHopByHop;
    }

    static {
        String ip;
        log = LoggerFactory.getLogger(CrankerMuHandler.class);
        HOP_BY_HOP = new HashSet<String>(Arrays.asList("keep-alive", "transfer-encoding", "te", "connection", "trailer", "upgrade", "proxy-authorization", "proxy-authenticate"));
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            ip = "unknown";
            log.info("Could not find local address so using " + ip);
        }
        ipAddress = ip;
        ArrayList<String> doNotForwardToTarget = new ArrayList<String>();
        doNotForwardToTarget.addAll(HOP_BY_HOP);
        doNotForwardToTarget.addAll(Arrays.asList("expect", "forwarded", "x-forwarded-by", "x-forwarded-for", "x-forwarded-host", "x-forwarded-proto", "x-forwarded-port", "x-forwarded-server", "via"));
        REPRESSED = new HashSet<String>(doNotForwardToTarget);
    }

    private static class ErrorProxyInfo
    implements ProxyInfo {
        private final boolean isCatchAll;
        private final String route;
        private final MuRequest clientRequest;
        private final MuResponse clientResponse;
        private final long socketWaitInMillis;
        private final long durationMillis;

        ErrorProxyInfo(String target, MuRequest clientRequest, MuResponse clientResponse, long socketWaitInMillis) {
            this.clientRequest = clientRequest;
            this.clientResponse = clientResponse;
            this.socketWaitInMillis = socketWaitInMillis;
            this.durationMillis = System.currentTimeMillis() - clientRequest.startTime();
            String[] split = target.split("/");
            if (split.length >= 2) {
                this.route = split[1];
                this.isCatchAll = false;
            } else {
                this.route = CrankerMuHandler.ANY_DOMAIN;
                this.isCatchAll = true;
            }
        }

        @Override
        public boolean isCatchAll() {
            return this.isCatchAll;
        }

        @Override
        public String connectorInstanceID() {
            return null;
        }

        @Override
        public InetSocketAddress serviceAddress() {
            return null;
        }

        @Override
        public String route() {
            return this.route;
        }

        @Override
        public MuRequest request() {
            return this.clientRequest;
        }

        @Override
        public MuResponse response() {
            return this.clientResponse;
        }

        @Override
        public long durationMillis() {
            return this.durationMillis;
        }

        @Override
        public long bytesReceived() {
            return 0L;
        }

        @Override
        public long bytesSent() {
            return 0L;
        }

        @Override
        public long responseBodyFrames() {
            return 0L;
        }

        @Override
        public Throwable errorIfAny() {
            return null;
        }

        @Override
        public long socketWaitInMillis() {
            return this.socketWaitInMillis;
        }
    }
}

