/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.HeadersBuilder;

class CrankerProtocolRequestBuilder {
    private static final String REQUEST_HAS_NO_BODY_MARKER = "_2";
    private static final String REQUEST_BODY_PENDING_MARKER = "_1";
    private static final String REQUEST_BODY_ENDED_MARKER = "_3";
    private String requestLine;
    private HeadersBuilder headers;
    private String endMarker;

    CrankerProtocolRequestBuilder() {
    }

    public static CrankerProtocolRequestBuilder newBuilder() {
        return new CrankerProtocolRequestBuilder();
    }

    public CrankerProtocolRequestBuilder withRequestLine(String requestLine) {
        this.requestLine = requestLine;
        return this;
    }

    public CrankerProtocolRequestBuilder withRequestHeaders(HeadersBuilder headers) {
        this.headers = headers;
        return this;
    }

    public CrankerProtocolRequestBuilder withRequestBodyPending() {
        this.endMarker = REQUEST_BODY_PENDING_MARKER;
        return this;
    }

    public CrankerProtocolRequestBuilder withRequestHasNoBody() {
        this.endMarker = REQUEST_HAS_NO_BODY_MARKER;
        return this;
    }

    public CrankerProtocolRequestBuilder withRequestBodyEnded() {
        this.endMarker = REQUEST_BODY_ENDED_MARKER;
        return this;
    }

    public String build() {
        if (this.requestLine != null && this.headers != null) {
            return this.requestLine + "\n" + this.headers + "\n" + this.endMarker;
        }
        return this.endMarker;
    }
}

