/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.CrankerMuHandler;
import com.hsbc.cranker.mucranker.CrankerProtocol;
import com.hsbc.cranker.mucranker.CrankerRouter;
import com.hsbc.cranker.mucranker.CrankerRouterImpl;
import com.hsbc.cranker.mucranker.DarkModeManagerImpl;
import com.hsbc.cranker.mucranker.IPValidator;
import com.hsbc.cranker.mucranker.ProxyListener;
import com.hsbc.cranker.mucranker.RouteResolver;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import com.hsbc.cranker.mucranker.WebSocketFarmV3Holder;
import io.muserver.Mutils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CrankerRouterBuilder {
    private IPValidator ipValidator = IPValidator.AllowAll;
    private boolean discardClientForwardedHeaders = false;
    private boolean sendLegacyForwardedHeaders = false;
    private String viaValue = "muc";
    private final Set<String> doNotProxyHeaders = new HashSet<String>();
    private long maxWaitInMillis = 5000L;
    private long pingAfterWriteMillis = 10000L;
    private long idleReadTimeoutMills = 60000L;
    private long routesKeepTimeMillis = 0x6DDD00L;
    private List<ProxyListener> completionListeners = Collections.emptyList();
    private RouteResolver routeResolver;
    private List<String> supportedCrankerProtocol = List.of("1.0", "3.0");

    public static CrankerRouterBuilder crankerRouter() {
        return new CrankerRouterBuilder();
    }

    public CrankerRouterBuilder withDiscardClientForwardedHeaders(boolean discardClientForwardedHeaders) {
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        return this;
    }

    public CrankerRouterBuilder withSendLegacyForwardedHeaders(boolean sendLegacyForwardedHeaders) {
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        return this;
    }

    public CrankerRouterBuilder withViaName(String viaName) {
        if (!viaName.matches("^[0-9a-zA-Z!#$%&'*+-.^_`|~:]+$")) {
            throw new IllegalArgumentException("Via names must be hostnames or HTTP header tokens");
        }
        this.viaValue = viaName;
        return this;
    }

    public CrankerRouterBuilder withIdleTimeout(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull((String)"unit", (Object)((Object)unit));
        this.idleReadTimeoutMills = unit.toMillis(duration);
        return this;
    }

    public CrankerRouterBuilder withRoutesKeepTime(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull((String)"unit", (Object)((Object)unit));
        this.routesKeepTimeMillis = unit.toMillis(duration);
        return this;
    }

    public CrankerRouterBuilder withPingSentAfterNoWritesFor(int duration, TimeUnit unit) {
        if (duration < 0) {
            throw new IllegalArgumentException("The duration must be 0 or greater");
        }
        Mutils.notNull((String)"unit", (Object)((Object)unit));
        this.pingAfterWriteMillis = unit.toMillis(duration);
        return this;
    }

    public CrankerRouterBuilder withConnectorMaxWaitInMillis(long maxWaitInMillis) {
        this.maxWaitInMillis = maxWaitInMillis;
        return this;
    }

    public CrankerRouterBuilder proxyHostHeader(boolean sendHostToTarget) {
        if (sendHostToTarget) {
            this.doNotProxyHeaders.remove("host");
        } else {
            this.doNotProxyHeaders.add("host");
        }
        return this;
    }

    public CrankerRouterBuilder withRegistrationIpValidator(IPValidator ipValidator) {
        Mutils.notNull((String)"ipValidator", (Object)ipValidator);
        this.ipValidator = ipValidator;
        return this;
    }

    public CrankerRouterBuilder withProxyListeners(List<ProxyListener> proxyListeners) {
        Mutils.notNull((String)"proxyListeners", proxyListeners);
        this.completionListeners = proxyListeners;
        return this;
    }

    public CrankerRouterBuilder withRouteResolver(RouteResolver routeResolver) {
        this.routeResolver = routeResolver;
        return this;
    }

    public CrankerRouterBuilder withSupportedCrankerProtocols(List<String> protocols) {
        if (protocols == null || protocols.isEmpty()) {
            throw new CrankerProtocol.CrankerProtocolVersionNotFoundException("protocols is null or empty");
        }
        List supportedProtocols = protocols.stream().filter(Objects::nonNull).map(String::toLowerCase).map(it -> it.replace("cranker_", "")).filter(it -> it.equalsIgnoreCase("1.0") || it.equalsIgnoreCase("3.0")).collect(Collectors.toList());
        if (supportedProtocols.isEmpty()) {
            throw new CrankerProtocol.CrankerProtocolVersionNotFoundException("protocols is empty after filter");
        }
        this.supportedCrankerProtocol = supportedProtocols;
        return this;
    }

    public CrankerRouter start() {
        HashSet<String> doNotProxy = new HashSet<String>(CrankerMuHandler.REPRESSED);
        this.doNotProxyHeaders.forEach(h -> doNotProxy.add(h.toLowerCase()));
        if (this.routeResolver == null) {
            this.routeResolver = new RouteResolver(){};
        }
        WebSocketFarm webSocketFarm = new WebSocketFarm(this.routeResolver, this.maxWaitInMillis);
        WebSocketFarmV3Holder webSocketFarmV3Holder = new WebSocketFarmV3Holder(this.routeResolver);
        webSocketFarm.start();
        ArrayList<ProxyListener> completionListeners = this.completionListeners.isEmpty() ? Collections.emptyList() : new ArrayList<ProxyListener>(this.completionListeners);
        DarkModeManagerImpl darkModeManager = new DarkModeManagerImpl(webSocketFarm);
        return new CrankerRouterImpl(this.ipValidator, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.viaValue, doNotProxy, webSocketFarm, webSocketFarmV3Holder, this.idleReadTimeoutMills, this.pingAfterWriteMillis, this.routesKeepTimeMillis, completionListeners, darkModeManager, this.supportedCrankerProtocol);
    }
}

