/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.ConnectorService;
import com.hsbc.cranker.mucranker.CrankerMuHandler;
import com.hsbc.cranker.mucranker.CrankerProtocol;
import com.hsbc.cranker.mucranker.CrankerRouter;
import com.hsbc.cranker.mucranker.DarkHost;
import com.hsbc.cranker.mucranker.DarkModeManager;
import com.hsbc.cranker.mucranker.IPValidator;
import com.hsbc.cranker.mucranker.ProxyListener;
import com.hsbc.cranker.mucranker.RouterInfo;
import com.hsbc.cranker.mucranker.RouterInfoImpl;
import com.hsbc.cranker.mucranker.RouterSocket;
import com.hsbc.cranker.mucranker.RouterSocketV3;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import com.hsbc.cranker.mucranker.WebSocketFarmV3;
import com.hsbc.cranker.mucranker.WebSocketFarmV3Holder;
import io.muserver.BaseWebSocket;
import io.muserver.ContextHandlerBuilder;
import io.muserver.Headers;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketSession;
import io.muserver.Mutils;
import io.muserver.WebSocketHandlerBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CrankerRouterImpl
implements CrankerRouter {
    private static final Logger log = LoggerFactory.getLogger(CrankerRouterImpl.class);
    private static final String CRANKER_PROTOCOL = "CrankerProtocol";
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final String VERSION_3 = "3.0";
    private static final String VERSION_1 = "1.0";
    private final IPValidator ipValidator;
    private final WebSocketFarm webSocketFarm;
    private final WebSocketFarmV3Holder webSocketFarmV3Holder;
    private final boolean discardClientForwardedHeaders;
    private final boolean sendLegacyForwardedHeaders;
    private final String viaValue;
    private final Set<String> doNotProxy;
    private final long idleTimeoutMillis;
    private final long pingScheduleMillis;
    private final long routesKeepTimeMillis;
    private final List<ProxyListener> proxyListeners;
    private final DarkModeManager darkModeManager;
    private final List<String> supportedCrankerProtocols;
    private final ScheduledExecutorService executor;

    CrankerRouterImpl(IPValidator ipValidator, boolean discardClientForwardedHeaders, boolean sendLegacyForwardedHeaders, String viaValue, Set<String> doNotProxy, WebSocketFarm webSocketFarm, WebSocketFarmV3Holder webSocketFarmV3Holder, long idleTimeoutMillis, long pingScheduleMillis, long routesKeepTimeMillis, List<ProxyListener> proxyListeners, DarkModeManager darkModeManager, List<String> supportedCrankerProtocol) {
        this.discardClientForwardedHeaders = discardClientForwardedHeaders;
        this.sendLegacyForwardedHeaders = sendLegacyForwardedHeaders;
        this.viaValue = viaValue;
        this.doNotProxy = doNotProxy;
        this.webSocketFarm = webSocketFarm;
        this.ipValidator = ipValidator;
        this.webSocketFarmV3Holder = webSocketFarmV3Holder;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.pingScheduleMillis = pingScheduleMillis;
        this.routesKeepTimeMillis = routesKeepTimeMillis;
        this.proxyListeners = proxyListeners;
        this.darkModeManager = darkModeManager;
        this.supportedCrankerProtocols = supportedCrankerProtocol;
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "cranker-router-cleanup"));
        if (routesKeepTimeMillis > 0L) {
            this.executor.scheduleWithFixedDelay(this::cleanRoute, routesKeepTimeMillis, routesKeepTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void cleanRoute() {
        try {
            this.webSocketFarm.cleanRoutes(this.routesKeepTimeMillis);
            this.webSocketFarmV3Holder.cleanRoutes(this.routesKeepTimeMillis);
        }
        catch (Throwable throwable) {
            log.warn("Exception on clean up routes", throwable);
        }
    }

    @Override
    public MuHandler createRegistrationHandler() {
        WebSocketHandlerBuilder registerHandler = WebSocketHandlerBuilder.webSocketHandler().withIdleReadTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS).withPingSentAfterNoWritesFor((int)this.pingScheduleMillis, TimeUnit.MILLISECONDS).withWebSocketFactory((request, responseHeaders) -> {
            CrankerRouterImpl.validateIpAddress(this.ipValidator, request);
            String version = CrankerRouterImpl.validateAndGetCrankerProtocolVersion(this.supportedCrankerProtocols, request);
            return this.connectorRegisterToRouter(request, responseHeaders, version);
        });
        WebSocketHandlerBuilder deregisterHandler = WebSocketHandlerBuilder.webSocketHandler().withWebSocketFactory((request, responseHeaders) -> {
            CrankerRouterImpl.validateIpAddress(this.ipValidator, request);
            String route = CrankerRouterImpl.getRoute(request);
            String connectorInstanceID = request.query().get("connectorInstanceID", null);
            if (connectorInstanceID == null) {
                log.info("the service" + route + " using unsupported zero down time connector, will not deregister socket");
            } else {
                String remoteAddr = request.remoteAddress();
                this.webSocketFarmV3Holder.deRegisterSocket(route, remoteAddr, connectorInstanceID);
                this.webSocketFarm.deRegisterSocket(route, remoteAddr, connectorInstanceID);
            }
            return new BaseWebSocket(){

                public void onConnect(MuWebSocketSession session) throws Exception {
                    super.onConnect(session);
                    try {
                        session.close(1000, "Deregister complete");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        });
        return ContextHandlerBuilder.context((String)"").addHandler((request, response) -> {
            if (request.method() == Method.TRACE) {
                throw new ClientErrorException("Method Not Allowed", 405);
            }
            return false;
        }).addHandler((MuHandler)registerHandler.withPath("/register/").build()).addHandler((MuHandler)registerHandler.withPath("/register").build()).addHandler((MuHandler)deregisterHandler.withPath("/deregister/").build()).addHandler((MuHandler)deregisterHandler.withPath("/deregister").build()).build();
    }

    private MuWebSocket connectorRegisterToRouter(MuRequest request, Headers responseHeaders, String version) {
        String negotiateVersion = "cranker_" + version;
        String subProtocol = request.headers().get(SEC_WEBSOCKET_PROTOCOL);
        if (subProtocol != null && subProtocol.contains(negotiateVersion)) {
            responseHeaders.set(SEC_WEBSOCKET_PROTOCOL, (Object)negotiateVersion);
        }
        String route = CrankerRouterImpl.getRoute(request);
        String domain = CrankerRouterImpl.getDomain(request);
        String componentName = request.query().get("componentName");
        String connectorInstanceID = request.query().get("connectorInstanceID", "unknown-" + request.remoteAddress());
        if (VERSION_3.equals(version)) {
            WebSocketFarmV3 webSocketFarmV3 = this.webSocketFarmV3Holder.getOrCreateWebSocketFarmV3(domain);
            RouterSocketV3 routerSocketV3 = new RouterSocketV3(route, componentName, webSocketFarmV3, connectorInstanceID, this.proxyListeners, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.viaValue, this.doNotProxy);
            routerSocketV3.setOnReadyForAction(() -> webSocketFarmV3.addWebSocket(route, routerSocketV3));
            return routerSocketV3;
        }
        responseHeaders.set(CRANKER_PROTOCOL, (Object)version);
        RouterSocket routerSocket = new RouterSocket(route, componentName, this.webSocketFarm, connectorInstanceID, this.proxyListeners);
        routerSocket.setOnReadyForAction(() -> this.webSocketFarm.addWebSocketAsync(route, routerSocket));
        return routerSocket;
    }

    private static String getRoute(MuRequest request) {
        String route = request.headers().get("Route");
        if (Mutils.nullOrEmpty((String)route)) {
            route = "*";
        }
        return route;
    }

    private static String getDomain(MuRequest request) {
        String route = request.headers().get("Domain");
        if (Mutils.nullOrEmpty((String)route)) {
            route = "*";
        }
        return route;
    }

    private static void validateIpAddress(IPValidator ipValidator, MuRequest request) {
        String remoteAddress = request.remoteAddress();
        if (!ipValidator.allow(remoteAddress)) {
            String errorMsg = "Fail to establish websocket connection to craker connector because of not supported ip address=" + remoteAddress + " the routerName=" + Mutils.htmlEncode((String)request.headers().get("Route"));
            log.warn(errorMsg);
            throw new ForbiddenException(errorMsg);
        }
    }

    @Override
    public int idleConnectionCount() {
        return this.webSocketFarm.idleCount() + this.webSocketFarmV3Holder.idleCount();
    }

    private static String validateAndGetCrankerProtocolVersion(List<String> supportedCrankerProtocols, MuRequest request) {
        String subProtocols = request.headers().get(SEC_WEBSOCKET_PROTOCOL);
        String legacyProtocolHeader = request.headers().get(CRANKER_PROTOCOL);
        if (subProtocols == null && legacyProtocolHeader == null) {
            throw new CrankerProtocol.CrankerProtocolVersionNotFoundException("version is null, please set header Sec-WebSocket-Protocol for cranker protocol negotiation");
        }
        if (subProtocols != null) {
            for (String subProtocol : subProtocols.split(",")) {
                String version = subProtocol.toLowerCase().trim().replace("cranker_", "");
                if (!supportedCrankerProtocols.contains(version)) continue;
                return version;
            }
        }
        if (legacyProtocolHeader != null && supportedCrankerProtocols.contains(legacyProtocolHeader)) {
            return legacyProtocolHeader;
        }
        throw new CrankerProtocol.CrankerProtocolVersionNotSupportedException("cranker protocol version not supported.");
    }

    @Override
    public MuHandler createHttpHandler() {
        return new CrankerMuHandler(this.webSocketFarm, this.webSocketFarmV3Holder, this.discardClientForwardedHeaders, this.sendLegacyForwardedHeaders, this.viaValue, this.doNotProxy, this.proxyListeners);
    }

    @Override
    public RouterInfo collectInfo() {
        Set<DarkHost> darkHosts = this.webSocketFarm.getDarkHosts();
        List<ConnectorService> services = RouterInfoImpl.getConnectorServiceList(this.webSocketFarm.getSockets(), this.webSocketFarmV3Holder.getSocketMaps(), darkHosts);
        return new RouterInfoImpl(services, darkHosts, this.webSocketFarm.getWaitingTasks());
    }

    @Override
    public void stop() {
        this.executor.shutdown();
        this.webSocketFarm.stop();
        this.webSocketFarmV3Holder.stop();
    }

    @Override
    public DarkModeManager darkModeManager() {
        return this.darkModeManager;
    }
}

