/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import io.muserver.ContentTypes;
import io.muserver.HeaderNames;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.NotFoundException;

public class FavIconHandler
implements MuHandler {
    private final byte[] favicon;

    private FavIconHandler(byte[] favicon) {
        this.favicon = favicon;
    }

    public static FavIconHandler fromClassPath(String iconPath) throws IOException {
        byte[] bytes;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             InputStream fav = FavIconHandler.class.getResourceAsStream(iconPath);){
            Mutils.copy((InputStream)fav, (OutputStream)baos, (int)8192);
            bytes = baos.toByteArray();
        }
        return new FavIconHandler(bytes);
    }

    public boolean handle(MuRequest req, MuResponse resp) throws Exception {
        String target = req.uri().getPath();
        if (target.equals("/favicon.ico") && req.method() == Method.GET) {
            if (this.favicon == null) {
                throw new NotFoundException();
            }
            resp.status(200);
            resp.contentType(ContentTypes.IMAGE_X_ICON);
            resp.headers().set(HeaderNames.CONTENT_LENGTH, (Object)this.favicon.length);
            resp.headers().set(HeaderNames.CACHE_CONTROL, (Object)"max-age=360000,public");
            resp.outputStream().write(this.favicon);
            return true;
        }
        return false;
    }
}

