/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.ConnectorConnection;
import com.hsbc.cranker.mucranker.ConnectorConnectionImpl;
import com.hsbc.cranker.mucranker.ConnectorInstance;
import com.hsbc.cranker.mucranker.ConnectorInstanceImpl;
import com.hsbc.cranker.mucranker.ConnectorService;
import com.hsbc.cranker.mucranker.ConnectorServiceImpl;
import com.hsbc.cranker.mucranker.DarkHost;
import com.hsbc.cranker.mucranker.RouterInfo;
import com.hsbc.cranker.mucranker.RouterSocket;
import com.hsbc.cranker.mucranker.RouterSocketV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class RouterInfoImpl
implements RouterInfo {
    private final List<ConnectorService> services;
    private final Set<DarkHost> darkHosts;
    private final Map<String, List<String>> waitingTasks;

    RouterInfoImpl(List<ConnectorService> services, Set<DarkHost> darkHosts, Map<String, List<String>> waitingTasks) {
        this.services = services;
        this.darkHosts = darkHosts;
        this.waitingTasks = waitingTasks;
    }

    @Override
    public List<ConnectorService> services() {
        return this.services;
    }

    @Override
    public Optional<ConnectorService> service(String routeName) {
        boolean isCatchAll = "*".equals(routeName);
        for (ConnectorService service : this.services) {
            if (isCatchAll && service.isCatchAll()) {
                return Optional.of(service);
            }
            if (!service.route().equals(routeName)) continue;
            return Optional.of(service);
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> i = new HashMap<String, Object>();
        for (ConnectorService service : this.services) {
            i.put(service.route(), service.toMap());
        }
        return i;
    }

    @Override
    public Set<DarkHost> darkHosts() {
        return this.darkHosts;
    }

    @Override
    public Map<String, List<String>> waitingTasks() {
        return this.waitingTasks;
    }

    public String toString() {
        return "RouterInfoImpl{services=" + this.services + "}";
    }

    static List<ConnectorService> getConnectorServiceList(Map<String, Queue<RouterSocket>> socketV1, Map<String, Map<String, List<RouterSocketV3>>> domainToSocketV3, Set<DarkHost> darkHosts) {
        ArrayList<ConnectorService> services = new ArrayList<ConnectorService>();
        Set uniqRoutes = Stream.concat(socketV1.keySet().stream(), domainToSocketV3.values().stream().flatMap(item -> item.keySet().stream())).collect(Collectors.toSet());
        for (String route : uniqRoutes) {
            HashMap<String, ConnectorInstance> instanceMap = new HashMap<String, ConnectorInstance>();
            ArrayList<ConnectorInstance> instances = new ArrayList<ConnectorInstance>();
            String componentName = null;
            for (RouterSocket routerSocket : (Queue)socketV1.getOrDefault(route, new LinkedList())) {
                componentName = routerSocket.componentName;
                String connectorInstanceID = routerSocket.connectorInstanceID();
                ConnectorInstance connectorInstance = (ConnectorInstance)instanceMap.get(connectorInstanceID);
                if (connectorInstance == null) {
                    connectorInstance = new ConnectorInstanceImpl(routerSocket.serviceAddress().getHostString(), connectorInstanceID, new ArrayList<ConnectorConnection>(), routerSocket.isDarkModeOn(darkHosts));
                    instanceMap.put(connectorInstanceID, connectorInstance);
                    instances.add(connectorInstance);
                }
                connectorInstance.connections().add(new ConnectorConnectionImpl("*", routerSocket.serviceAddress().getPort(), routerSocket.routerSocketID, routerSocket.getProtocol(), 0));
            }
            for (String domain : domainToSocketV3.keySet()) {
                Map<String, List<RouterSocketV3>> domainSocketsV3 = domainToSocketV3.get(domain);
                for (RouterSocketV3 routerSocketV3 : (List)domainSocketsV3.getOrDefault(route, new LinkedList())) {
                    componentName = routerSocketV3.componentName;
                    String connectorInstanceID = routerSocketV3.connectorInstanceID();
                    ConnectorInstance connectorInstance = (ConnectorInstance)instanceMap.get(connectorInstanceID);
                    if (connectorInstance == null) {
                        connectorInstance = new ConnectorInstanceImpl(routerSocketV3.serviceAddress().getHostString(), connectorInstanceID, new ArrayList<ConnectorConnection>(), false);
                        instanceMap.put(connectorInstanceID, connectorInstance);
                        instances.add(connectorInstance);
                    }
                    connectorInstance.connections().add(new ConnectorConnectionImpl(domain, routerSocketV3.serviceAddress().getPort(), routerSocketV3.routerSocketID, routerSocketV3.getProtocol(), routerSocketV3.getContextMap().size()));
                }
            }
            services.add(new ConnectorServiceImpl(route, componentName, instances));
        }
        return services;
    }
}

