/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.CrankerMuHandler;
import com.hsbc.cranker.mucranker.CrankerProtocolResponse;
import com.hsbc.cranker.mucranker.DarkHost;
import com.hsbc.cranker.mucranker.ProxyInfo;
import com.hsbc.cranker.mucranker.ProxyListener;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import io.muserver.AsyncHandle;
import io.muserver.BaseWebSocket;
import io.muserver.DoneCallback;
import io.muserver.HeaderNames;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.MuWebSocketSession;
import io.muserver.Mutils;
import io.muserver.WebsocketSessionState;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RouterSocket
extends BaseWebSocket
implements ProxyInfo {
    private static final Logger log = LoggerFactory.getLogger(RouterSocket.class);
    private static final List<String> RESPONSE_HEADERS_TO_NOT_SEND_BACK = Collections.singletonList("server");
    final String route;
    final String componentName;
    final String routerSocketID = UUID.randomUUID().toString();
    private final WebSocketFarm webSocketFarm;
    private final String connectorInstanceID;
    private final List<ProxyListener> proxyListeners;
    private Runnable onReadyForAction;
    private InetSocketAddress remoteAddress;
    private boolean isRemoved;
    private boolean hasResponse;
    private final AtomicLong bytesReceived = new AtomicLong();
    private final AtomicLong bytesSent = new AtomicLong();
    private final AtomicLong binaryFramesReceived = new AtomicLong();
    private AsyncHandle asyncHandle;
    private MuResponse response;
    private MuRequest clientRequest;
    private long socketWaitInMillis;
    private Throwable error;
    private long durationMillis = 0L;
    private StringBuilder onTextBuffer;

    RouterSocket(String route, String componentName, WebSocketFarm webSocketFarm, String remotePort, List<ProxyListener> proxyListeners) {
        this.webSocketFarm = webSocketFarm;
        this.route = route;
        this.componentName = componentName;
        this.connectorInstanceID = remotePort;
        this.proxyListeners = proxyListeners;
        this.isRemoved = false;
        this.hasResponse = false;
    }

    @Override
    public boolean isCatchAll() {
        return "*".equals(this.route);
    }

    void socketSessionClose() {
        try {
            MuWebSocketSession session = this.session();
            if (session != null) {
                session.close(1001, "Going away");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onConnect(MuWebSocketSession session) throws Exception {
        super.onConnect(session);
        this.remoteAddress = session.remoteAddress();
        this.onReadyForAction.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientClosed(int statusCode, String reason) throws Exception {
        super.onClientClosed(statusCode, reason);
        try {
            if (!this.proxyListeners.isEmpty()) {
                for (ProxyListener proxyListener : this.proxyListeners) {
                    proxyListener.onResponseBodyChunkReceived(this);
                }
            }
            if (this.hasResponse && !this.response.hasStartedSendingData()) {
                if (statusCode == 1011) {
                    this.response.status(502);
                } else if (statusCode == 1008) {
                    this.response.status(400);
                }
            }
            if (this.asyncHandle != null) {
                try {
                    if (statusCode == 1000) {
                        this.asyncHandle.complete();
                    } else {
                        log.info("Closing client request early due to cranker wss connection close with status code {} {}", (Object)statusCode, (Object)reason);
                        this.asyncHandle.complete((Throwable)new RuntimeException("Upstream Server Error"));
                    }
                }
                catch (IllegalStateException e) {
                    log.info("Tried to complete a request, but it is probably already closed.  routerName=" + this.route + ", routerSocketID=" + this.routerSocketID, (Throwable)e);
                }
            }
            if (!this.isRemoved) {
                this.webSocketFarm.removeWebSocketAsync(this.route, this, () -> {});
                this.isRemoved = true;
            }
        }
        finally {
            this.raiseCompletionEvent();
        }
    }

    private void raiseCompletionEvent() {
        if (this.clientRequest != null && !this.proxyListeners.isEmpty()) {
            this.durationMillis = System.currentTimeMillis() - this.clientRequest.startTime();
            for (ProxyListener completionListener : this.proxyListeners) {
                try {
                    completionListener.onComplete(this);
                }
                catch (Exception e) {
                    log.warn("Error thrown by " + completionListener, (Throwable)e);
                }
            }
        }
    }

    public void onError(Throwable cause) throws Exception {
        try {
            this.error = cause;
            super.onError(cause);
            this.removeBadWebSocket();
            if (cause instanceof TimeoutException) {
                if (this.response != null && !this.response.hasStartedSendingData()) {
                    String htmlBody = "The <code>" + Mutils.htmlEncode((String)this.route) + "</code> service did not respond in time.";
                    CrankerMuHandler.sendSimpleResponse(this.response, this.asyncHandle, 504, "504 Gateway Timeout", htmlBody);
                } else if (this.asyncHandle != null) {
                    log.info("Closing client request early due to timeout");
                    this.asyncHandle.complete(cause);
                }
            } else if (this.response != null && !this.response.hasStartedSendingData()) {
                String htmlBody = "The <code>" + Mutils.htmlEncode((String)this.route) + "</code> service error.";
                CrankerMuHandler.sendSimpleResponse(this.response, this.asyncHandle, 502, "502 Bad Gateway", htmlBody);
            } else if (this.asyncHandle != null) {
                log.info("Closing client request early due to cranker wss connection error", cause);
                this.asyncHandle.complete(cause);
            }
        }
        finally {
            this.raiseCompletionEvent();
        }
    }

    public void onText(String message, boolean isLast, DoneCallback doneCallback) throws Exception {
        WebsocketSessionState websocketState = this.state();
        if (!this.hasResponse || websocketState.endState()) {
            doneCallback.onComplete((Throwable)new IllegalStateException("Received text message from connector but hasResponse=" + this.hasResponse + " and state=" + websocketState));
            return;
        }
        if (!isLast && this.onTextBuffer == null) {
            this.onTextBuffer = new StringBuilder();
        }
        if (this.onTextBuffer != null) {
            this.onTextBuffer.append(message);
            if (this.onTextBuffer.length() > 65536) {
                doneCallback.onComplete((Throwable)new RuntimeException("response header too large"));
                return;
            }
        }
        if (isLast) {
            String messageToApply = this.onTextBuffer != null ? this.onTextBuffer.toString() : message;
            CrankerProtocolResponse protocolResponse = new CrankerProtocolResponse(messageToApply);
            this.response.status(protocolResponse.getStatus());
            this.putHeadersTo(protocolResponse);
            try {
                if (!this.proxyListeners.isEmpty()) {
                    for (ProxyListener proxyListener : this.proxyListeners) {
                        proxyListener.onBeforeRespondingToClient(this);
                        proxyListener.onAfterTargetToProxyHeadersReceived(this, protocolResponse.getStatus(), this.response.headers());
                    }
                }
            }
            catch (WebApplicationException e) {
                CrankerMuHandler.handleWebApplicationException(e, this.response, this.asyncHandle);
            }
            this.bytesSent.getAndAdd(message.length());
        }
        doneCallback.onComplete(null);
    }

    public void onBinary(ByteBuffer byteBuffer, boolean isLast, DoneCallback doneCallback) throws Exception {
        WebsocketSessionState websocketState = this.state();
        if (!this.hasResponse || websocketState.endState()) {
            doneCallback.onComplete((Throwable)new IllegalStateException("Received binary message from connector but hasResponse=" + this.hasResponse + " and state=" + websocketState));
            return;
        }
        this.binaryFramesReceived.incrementAndGet();
        int len = byteBuffer.remaining();
        if (len == 0) {
            log.warn("routerName=" + this.route + ", routerSocketID=" + this.routerSocketID + ", received 0 bytes to send to " + this.remoteAddress + " - " + this.response);
            doneCallback.onComplete(null);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("routerName=" + this.route + ", routerSocketID=" + this.routerSocketID + ", sending " + len + " bytes to client");
            }
            int position = byteBuffer.position();
            this.asyncHandle.write(byteBuffer, errorIfAny -> {
                try {
                    if (errorIfAny == null) {
                        this.bytesSent.addAndGet(len);
                    } else {
                        log.info("routerName=" + this.route + ", routerSocketID=" + this.routerSocketID + ", could not write to client response (maybe the user closed their browser) so will cancel the request. Error message: " + errorIfAny.getMessage());
                    }
                    if (!this.proxyListeners.isEmpty()) {
                        for (ProxyListener proxyListener : this.proxyListeners) {
                            proxyListener.onResponseBodyChunkReceivedFromTarget(this, byteBuffer.position(position));
                        }
                    }
                }
                catch (Throwable throwable) {
                    log.warn("something wrong after sending bytes to cranker", throwable);
                }
                finally {
                    doneCallback.onComplete(errorIfAny);
                }
            });
        }
    }

    void sendText(String message) {
        this.bytesReceived.getAndAdd(message.length());
        this.session().sendText(message, DoneCallback.NoOp);
    }

    void sendData(ByteBuffer bb, DoneCallback callback) {
        this.bytesReceived.getAndAdd(bb.remaining());
        this.session().sendBinary(bb, callback);
    }

    private void removeBadWebSocket() {
        if (!this.isRemoved) {
            this.socketSessionClose();
            this.webSocketFarm.removeWebSocketAsync(this.route, this, () -> {});
            this.isRemoved = true;
        }
    }

    @Override
    public String connectorInstanceID() {
        return this.connectorInstanceID;
    }

    void setOnReadyForAction(Runnable onReadyForAction) {
        this.onReadyForAction = onReadyForAction;
    }

    @Override
    public InetSocketAddress serviceAddress() {
        return this.remoteAddress;
    }

    private void putHeadersTo(CrankerProtocolResponse protocolResponse) {
        this.response.headers().remove("date");
        for (String line : protocolResponse.headers) {
            String header;
            String lowerHeader;
            int pos = line.indexOf(58);
            if (pos <= 0 || CrankerMuHandler.HOP_BY_HOP.contains(lowerHeader = (header = line.substring(0, pos)).toLowerCase()) || RESPONSE_HEADERS_TO_NOT_SEND_BACK.contains(lowerHeader)) continue;
            String value = line.substring(pos + 1);
            this.response.headers().add(lowerHeader, (Object)value);
        }
        List<String> customHopByHop = CrankerMuHandler.getCustomHopByHopHeaders(this.response.headers().get(HeaderNames.CONNECTION));
        for (String header : customHopByHop) {
            this.response.headers().remove(header);
        }
    }

    void setAsyncHandle(AsyncHandle asyncHandle, MuRequest clientRequest, MuResponse response, long socketWaitInMillis) {
        this.clientRequest = clientRequest;
        this.socketWaitInMillis = socketWaitInMillis;
        this.hasResponse = true;
        this.response = response;
        this.asyncHandle = asyncHandle;
        asyncHandle.addResponseCompleteHandler(info -> {
            if (!info.completedSuccessfully() && !this.state().endState()) {
                log.info("Closing socket because client request did not complete successfully for " + clientRequest);
                this.socketSessionClose();
                this.raiseCompletionEvent();
            }
        });
    }

    boolean isDarkModeOn(Set<DarkHost> darkHosts) {
        InetAddress thisSocketAddress = this.serviceAddress().getAddress();
        for (DarkHost darkHost : darkHosts) {
            if (!darkHost.sameHost(thisSocketAddress)) continue;
            return true;
        }
        return false;
    }

    public String getProtocol() {
        return "cranker_1.0";
    }

    @Override
    public String route() {
        return this.route;
    }

    @Override
    public MuRequest request() {
        return this.clientRequest;
    }

    @Override
    public MuResponse response() {
        return this.response;
    }

    @Override
    public long durationMillis() {
        return this.durationMillis;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived.get();
    }

    @Override
    public long bytesSent() {
        return this.bytesSent.get();
    }

    @Override
    public long responseBodyFrames() {
        return this.binaryFramesReceived.get();
    }

    @Override
    public Throwable errorIfAny() {
        return this.error;
    }

    @Override
    public long socketWaitInMillis() {
        return this.socketWaitInMillis;
    }
}

