/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.RouteResolver;
import com.hsbc.cranker.mucranker.RouterSocketV3;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import io.muserver.HeaderNames;
import io.muserver.MuResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketFarmV3 {
    private static final Logger log = LoggerFactory.getLogger(WebSocketFarmV3.class);
    private final AtomicInteger idleCount = new AtomicInteger(0);
    private final RouteResolver routeResolver;
    private final Map<String, List<RouterSocketV3>> sockets = new ConcurrentHashMap<String, List<RouterSocketV3>>();
    private final Map<String, Long> routeLastRemovalTimes = new ConcurrentHashMap<String, Long>();
    private final Map<String, Integer> indexMap = new ConcurrentHashMap<String, Integer>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "websocket-farm-v3-execution"));

    public WebSocketFarmV3(RouteResolver routeResolver) {
        this.routeResolver = routeResolver;
    }

    public void start() {
    }

    public void stop() {
        this.executor.shutdown();
        for (List<RouterSocketV3> sockets : this.sockets.values()) {
            for (RouterSocketV3 RouterSocketV32 : sockets) {
                RouterSocketV32.socketSessionClose();
            }
        }
        this.sockets.clear();
    }

    public void cleanRoutes(long routesKeepTimeMillis) {
        long cutoffTime = System.currentTimeMillis() - routesKeepTimeMillis;
        this.sockets.entrySet().stream().filter(entry -> entry.getValue() != null && ((List)entry.getValue()).size() == 0 && this.routeLastRemovalTimes.containsKey(entry.getKey()) && this.routeLastRemovalTimes.get(entry.getKey()) < cutoffTime).forEach(entry -> {
            log.info("removing registration info for {}, consequence requests to {} will receive 404", entry.getKey(), entry.getKey());
            this.sockets.remove(entry.getKey());
            this.routeLastRemovalTimes.remove(entry.getKey());
        });
    }

    public boolean canHandle(String target, boolean useCatchAll) {
        String routeKey = this.resolveRouteKey(target, useCatchAll);
        if (routeKey == null) {
            return false;
        }
        List<RouterSocketV3> routeSockets = this.sockets.get(routeKey);
        return routeSockets != null && routeSockets.size() > 0;
    }

    private String resolveRouteKey(String target, boolean useCatchAll) {
        String resolved = this.routeResolver.resolve(this.sockets.keySet(), target);
        if (!useCatchAll && (resolved == null || "*".equals(resolved))) {
            return null;
        }
        return Objects.requireNonNullElse(resolved, "*");
    }

    public Map<String, List<RouterSocketV3>> getSockets() {
        HashMap<String, List<RouterSocketV3>> clone = new HashMap<String, List<RouterSocketV3>>();
        for (Map.Entry<String, List<RouterSocketV3>> routeEntry : this.sockets.entrySet()) {
            clone.put(routeEntry.getKey(), new ArrayList(routeEntry.getValue()));
        }
        return clone;
    }

    public CompletableFuture<RouterSocketV3> removeWebSocket(RouterSocketV3 socket) {
        CompletableFuture<RouterSocketV3> future = new CompletableFuture<RouterSocketV3>();
        this.executor.submit(() -> WebSocketFarm.ThrowingFunction.logIfFail(() -> {
            this.routeLastRemovalTimes.put(socket.route, System.currentTimeMillis());
            List<RouterSocketV3> RouterSocketV3s = this.sockets.get(socket.route);
            if (RouterSocketV3s != null && RouterSocketV3s.remove((Object)socket)) {
                this.idleCount.decrementAndGet();
                future.complete(socket);
                return;
            }
            future.complete(null);
        }));
        return future;
    }

    public CompletableFuture<Boolean> addWebSocket(String route, RouterSocketV3 socket) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.executor.submit(() -> WebSocketFarm.ThrowingFunction.logIfFail(() -> {
            this.sockets.putIfAbsent(route, new ArrayList());
            List<RouterSocketV3> routeSockets = this.sockets.get(route);
            if (!routeSockets.contains((Object)socket)) {
                routeSockets.add(socket);
                this.idleCount.incrementAndGet();
            }
            future.complete(true);
        }));
        return future;
    }

    public CompletableFuture<RouterSocketV3> getWebSocket(String target, boolean useCatchAll) {
        CompletableFuture<RouterSocketV3> future = new CompletableFuture<RouterSocketV3>();
        this.executor.submit(() -> {
            try {
                String routeKey = this.resolveRouteKey(target, useCatchAll);
                if (routeKey == null) {
                    log.warn("failed to get available websocket for target={}, useCatchAll={}", (Object)target, (Object)useCatchAll);
                    future.completeExceptionally(new IllegalStateException("failed to get available websocket for target " + target + ", useCatchAll=" + useCatchAll));
                    return;
                }
                List<RouterSocketV3> routeSockets = this.sockets.get(routeKey);
                if (routeSockets == null || routeSockets.size() == 0) {
                    future.complete(null);
                    return;
                }
                int indexNext = this.indexMap.getOrDefault(routeKey, -1) + 1;
                if (indexNext > routeSockets.size() - 1) {
                    indexNext = 0;
                }
                this.indexMap.put(routeKey, indexNext);
                RouterSocketV3 socket = routeSockets.get(indexNext);
                future.complete(socket);
            }
            catch (Throwable throwable) {
                log.warn("failed to get available websocket for " + target, throwable);
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    public void deRegisterSocket(String target, String remoteAddr, String connectorInstanceID) {
        log.info("Going to deregister targetName=" + target + " and the targetAddr=" + remoteAddr + " and the connectorInstanceID=" + connectorInstanceID);
        List<RouterSocketV3> routerSocketV3s = this.sockets.get(target);
        if (routerSocketV3s != null) {
            for (RouterSocketV3 socket : new LinkedList<RouterSocketV3>(routerSocketV3s)) {
                if (!socket.connectorInstanceID().equals(connectorInstanceID)) continue;
                this.removeWebSocket(socket).whenComplete((routerSocketV3, throwable) -> WebSocketFarm.ThrowingFunction.logIfFail(() -> {
                    if (routerSocketV3 != null) {
                        routerSocketV3.socketSessionClose();
                    }
                }));
            }
        }
    }

    public int idleCount() {
        return this.idleCount.get();
    }

    public static boolean isSSE(MuResponse response) {
        return response != null && "text/event-stream".equals(response.headers().get(HeaderNames.CONTENT_TYPE));
    }

    public Map<String, Object> getRouteMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, List<RouterSocketV3>> routeEntry : this.getSockets().entrySet()) {
            result.put(routeEntry.getKey(), routeEntry.getValue().stream().sorted(Comparator.comparing(a -> a.serviceAddress().getHostString())).map(item -> Map.of("componentName", item.componentName, "connectorInstanceID", item.connectorInstanceID(), "ip", item.serviceAddress().getHostString(), "port", item.serviceAddress().getPort(), "inflightCount", item.getContextMap().size(), "inflightRequests", item.getContextMap().values().stream().map(context -> {
                if (context.request != null) {
                    return Map.of("id", context.requestId, "isSSE", WebSocketFarmV3.isSSE(context.response), "startTime", Instant.ofEpochMilli(context.request.startTime()), "duration", System.currentTimeMillis() - context.request.startTime(), "requestsMethod", context.request.method(), "requestsPath", context.request.relativePath());
                }
                return Map.of("id", context.requestId);
            }).collect(Collectors.toList()))).collect(Collectors.toList()));
        }
        return result;
    }
}

