/*
 * Decompiled with CFR 0.152.
 */
package com.hsbc.cranker.mucranker;

import com.hsbc.cranker.mucranker.RouteResolver;
import com.hsbc.cranker.mucranker.RouterSocketV3;
import com.hsbc.cranker.mucranker.WebSocketFarm;
import com.hsbc.cranker.mucranker.WebSocketFarmV3;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class WebSocketFarmV3Holder {
    private final Map<String, WebSocketFarmV3> domainToFarmMap;
    private final RouteResolver routeResolver;

    public WebSocketFarmV3Holder(RouteResolver routeResolver) {
        this.routeResolver = routeResolver;
        this.domainToFarmMap = new ConcurrentHashMap<String, WebSocketFarmV3>();
    }

    public void start() {
    }

    public void stop() {
        for (WebSocketFarmV3 farm : this.domainToFarmMap.values()) {
            WebSocketFarm.ThrowingFunction.logIfFail(farm::stop);
        }
        this.domainToFarmMap.clear();
    }

    public void cleanRoutes(long routesKeepTimeMillis) {
        for (WebSocketFarmV3 farm : this.domainToFarmMap.values()) {
            farm.cleanRoutes(routesKeepTimeMillis);
        }
    }

    public WebSocketFarmV3 getOrCreateWebSocketFarmV3(String domain) {
        return this.domainToFarmMap.computeIfAbsent(domain, k -> new WebSocketFarmV3(this.routeResolver));
    }

    public WebSocketFarmV3 getWebSocketFarmV3(String domain) {
        return this.domainToFarmMap.get(domain);
    }

    public Map<String, Map<String, List<RouterSocketV3>>> getSocketMaps() {
        HashMap<String, Map<String, List<RouterSocketV3>>> clone = new HashMap<String, Map<String, List<RouterSocketV3>>>();
        for (Map.Entry<String, WebSocketFarmV3> farmEntry : this.domainToFarmMap.entrySet()) {
            clone.put(farmEntry.getKey(), farmEntry.getValue().getSockets());
        }
        return clone;
    }

    public int idleCount() {
        return this.domainToFarmMap.values().stream().mapToInt(WebSocketFarmV3::idleCount).sum();
    }

    public boolean canHandle(String domain, String target, boolean useCatchAll) {
        WebSocketFarmV3 farm = this.domainToFarmMap.get(domain);
        return farm != null && farm.canHandle(target, useCatchAll);
    }

    public void deRegisterSocket(String target, String remoteAddr, String connectorInstanceID) {
        for (WebSocketFarmV3 webSocketFarmV3 : this.domainToFarmMap.values()) {
            WebSocketFarm.ThrowingFunction.logIfFail(() -> webSocketFarmV3.deRegisterSocket(target, remoteAddr, connectorInstanceID));
        }
    }
}

